/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.EtFuturumLootTables;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.CompostingRegistry;
import ganymedes01.etfuturum.api.inventory.FakeTileEntityProvider;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import ganymedes01.etfuturum.tileentities.fake.TileEntityFakeInventory;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockComposter
extends Block
implements FakeTileEntityProvider {
    private IIcon topIcon;
    private IIcon bottomIcon;
    public IIcon compostIcon;
    public IIcon fullCompostIcon;
    public static int FULL_META = 7;
    public static int HARVESTABLE_META = 8;
    private static final int[] SLOTS_NONE = new int[0];
    private static final int[] SLOTS_SINGLE = new int[]{0};

    public BlockComposter() {
        super(Material.field_151575_d);
        this.func_149672_a(field_149766_f);
        this.func_149711_c(0.6f);
        this.func_149752_b(0.6f);
        this.setHarvestLevel("axe", 0);
        this.func_149663_c(Utils.getUnlocalisedName("composter"));
        this.func_149658_d("composter");
        this.func_149713_g(500);
        this.func_149647_a(EtFuturum.creativeTabBlocks);
        this.func_149713_g(0);
        this.field_149783_u = true;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : (side == 0 ? this.bottomIcon : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "_side");
        this.bottomIcon = reg.func_94245_a(this.func_149641_N() + "_bottom");
        this.topIcon = reg.func_94245_a(this.func_149641_N() + "_top");
        this.compostIcon = reg.func_94245_a(this.func_149641_N() + "_compost");
        this.fullCompostIcon = reg.func_94245_a(this.func_149641_N() + "_ready");
    }

    public void func_149743_a(World worldIn, int x, int y, int z, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collider) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        super.func_149743_a(worldIn, x, y, z, mask, list, collider);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        super.func_149743_a(worldIn, x, y, z, mask, list, collider);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        super.func_149743_a(worldIn, x, y, z, mask, list, collider);
        this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(worldIn, x, y, z, mask, list, collider);
        this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(worldIn, x, y, z, mask, list, collider);
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public static boolean addToComposter(World world, int x, int y, int z, ItemStack stack) {
        int chance = CompostingRegistry.getCompostChance(stack);
        int meta = world.func_72805_g(x, y, z);
        if (chance > 0) {
            int fillAmount = (int)((float)chance * 0.01f) + (world.field_73012_v.nextInt(100) < chance % 100 ? 1 : 0);
            if (fillAmount > 0) {
                world.func_72921_c(x, y, z, Math.min(meta + fillAmount, FULL_META), 3);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.21:block.composter.fill_success", 1.0f, 1.0f);
                if (fillAmount + meta >= FULL_META) {
                    world.func_147464_a(x, y, z, ModBlocks.COMPOSTER.get(), world.field_73012_v.nextInt(10) + 10);
                }
            } else {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.21:block.composter.fill", 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < FULL_META) {
            ItemStack stack = player.func_71045_bC();
            int chance = CompostingRegistry.getCompostChance(stack);
            if (chance > 0) {
                if (!world.field_72995_K) {
                    BlockComposter.addToComposter(world, x, y, z, stack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                for (int i = 0; i <= 5; ++i) {
                    world.func_72869_a("happyVillager", world.field_73012_v.nextDouble() * 0.875 + 0.125 + (double)x, 0.25 + 0.125 * (double)meta + (double)y, world.field_73012_v.nextDouble() * 0.875 + 0.125 + (double)z, 0.0, 0.0, 0.0);
                }
                return true;
            }
        } else if (meta == HARVESTABLE_META) {
            if (!world.field_72995_K) {
                EntityItem item = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, EtFuturumLootTables.COMPOSTER_LOOT.getOneItem(world.field_73012_v));
                item.field_70159_w = world.field_73012_v.nextDouble() * 0.5;
                item.field_70181_x = 0.0;
                item.field_70179_y = world.field_73012_v.nextDouble() * 0.5;
                world.func_72838_d((Entity)item);
            }
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.21:block.composter.empty", 1.0f, 1.0f, true);
            world.func_72921_c(x, y, z, 0, 3);
            return true;
        }
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == FULL_META) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.21:block.composter.ready", 1.0f, 1.0f);
            world.func_72921_c(x, y, z, HARVESTABLE_META, 3);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.COMPOSTER;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @Override
    public TileEntity getFakeTileEntity(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        InventoryDummy targetInv = meta < FULL_META ? new InventoryEmptyComposter(world, x, y, z) : (meta == HARVESTABLE_META ? new InventoryFullComposter(world, x, y, z) : new InventoryDummy(world, x, y, z));
        return new TileEntityFakeInventory(targetInv);
    }

    static class InventoryEmptyComposter
    extends InventoryDummy {
        public InventoryEmptyComposter(World world, int x, int y, int z) {
            super(world, x, y, z, "composter", 1);
        }

        @Override
        public int[] func_94128_d(int p_94128_1_) {
            return p_94128_1_ == 1 ? SLOTS_SINGLE : SLOTS_NONE;
        }

        @Override
        public boolean func_102007_a(int slot, ItemStack p_102007_2_, int side) {
            return !this.dirty && side == 1 && BlockComposter.addToComposter(this.world, this.x, this.y, this.z, p_102007_2_);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.func_70296_d();
        }
    }

    static class InventoryFullComposter
    extends InventoryDummy {
        public InventoryFullComposter(World world, int x, int y, int z) {
            super(world, x, y, z, "composter_full", 1);
            this.func_70299_a(0, EtFuturumLootTables.COMPOSTER_LOOT.getOneItem(world.field_73012_v));
        }

        @Override
        public int[] func_94128_d(int p_94128_1_) {
            return p_94128_1_ == 0 ? SLOTS_SINGLE : SLOTS_NONE;
        }

        @Override
        public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
            if (p_102008_3_ == 0) {
                this.world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "minecraft_1.21:block.composter.empty", 1.0f, 1.0f, true);
                this.world.func_72921_c(this.x, this.y, this.z, 0, 3);
                return true;
            }
            return false;
        }
    }

    static class InventoryDummy
    extends InventoryBasic
    implements ISidedInventory {
        protected final int x;
        protected final int y;
        protected final int z;
        protected final World world;
        protected boolean dirty;

        public InventoryDummy(World world, int x, int y, int z, String name, int slots) {
            super(name, false, slots);
            this.x = x;
            this.y = y;
            this.z = z;
            this.world = world;
        }

        public InventoryDummy(World world, int x, int y, int z) {
            this(world, x, y, z, "dummy", 0);
        }

        public int[] func_94128_d(int p_94128_1_) {
            return SLOTS_NONE;
        }

        public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
            return false;
        }

        public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
            this.dirty = true;
        }
    }
}

