/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.IAltarManipulator;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBloodLetterPack
extends ItemArmor
implements ArmourUpgrade,
IAltarManipulator {
    @SideOnly(value=Side.CLIENT)
    private IIcon plateIcon;
    public int conversionRate = 100;
    public float activationPoint = 0.5f;
    public int tickRate = 20;
    public int maxStored = 10000;

    public ItemBloodLetterPack() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, 1);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.plateIcon = iconRegister.func_94245_a("AlchemicalWizardry:BloodPack");
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.bloodletterpack.desc"));
        if (par1ItemStack.func_77978_p() != null) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.lp.storedlp") + " " + this.getStoredLP(par1ItemStack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.plateIcon;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/bloodPack_layer_1.png";
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition == null) {
            return super.func_77659_a(itemStack, world, player);
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int amount;
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TEAltar)) {
                return super.func_77659_a(itemStack, world, player);
            }
            TEAltar altar = (TEAltar)tile;
            if (!altar.isActive() && (amount = this.getStoredLP(itemStack)) > 0) {
                int filledAmount = altar.fillMainTank(amount);
                this.setStoredLP(itemStack, amount -= filledAmount);
                world.func_147471_g(x, y, z);
            }
        }
        return itemStack;
    }

    public void setStoredLP(ItemStack itemStack, int lp) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        tag.func_74768_a("storedLP", lp);
    }

    public int getStoredLP(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        return tag.func_74762_e("storedLP");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_82737_E() % (long)this.tickRate == 0L) {
            boolean shouldExecute;
            boolean bl = shouldExecute = player.func_110143_aJ() / player.func_110138_aP() > this.activationPoint && this.getStoredLP(itemStack) < this.maxStored;
            if (shouldExecute) {
                SoulNetworkHandler.hurtPlayer(player, 1.0f);
                this.setStoredLP(itemStack, Math.min(this.getStoredLP(itemStack) + this.conversionRate, this.maxStored));
            }
        }
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 0;
    }
}

