/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.crafting.v2.CraftingJobV2;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.IOUtils;

public class PacketCraftingTreeData
extends AppEngPacket {
    private static final int CHUNK_SIZE = 0x100000;
    private ByteBuf receivedData = null;
    private static final WeakHashMap<EntityPlayer, ByteBuf[]> chunkStorage = new WeakHashMap();

    public PacketCraftingTreeData(ByteBuf stream) throws IOException {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            throw new UnsupportedOperationException("A client tried to use a client-only packet on the server.");
        }
        this.receivedData = stream.slice();
    }

    private PacketCraftingTreeData(ByteBuf chunkData, int chunkId, int totalChunks) {
        ByteBuf output = Unpooled.buffer((int)(12 + chunkData.readableBytes()));
        output.writeInt(this.getPacketID());
        output.writeInt(chunkId);
        output.writeInt(totalChunks);
        output.writeBytes(chunkData);
        this.configureWrite(output);
    }

    public static List<PacketCraftingTreeData> createChunks(CraftingJobV2 job) {
        ByteBuf jobData = job.serialize();
        ByteBuf output = Unpooled.buffer((int)(jobData.readableBytes() + 4));
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(output);
             GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)bbos);
             ByteBufInputStream bbis = new ByteBufInputStream(jobData);){
            IOUtils.copy((InputStream)bbis, (OutputStream)gzos);
            gzos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int chunkCount = (int)Platform.ceilDiv(output.readableBytes(), 0x100000L);
        ArrayList<PacketCraftingTreeData> chunks = new ArrayList<PacketCraftingTreeData>(chunkCount);
        for (int chunk = 0; chunk < chunkCount; ++chunk) {
            int start = 0x100000 * chunk;
            int end = Math.min(start + 0x100000, output.readableBytes());
            int len = end - start;
            chunks.add(new PacketCraftingTreeData(output.slice(start, len), chunk, chunkCount));
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.DebugLogging)) {
            AELog.info("Crafting tree packet raw size %d, compressed %d, chunk count %d", jobData.writerIndex(), output.readableBytes(), chunks.size());
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        if (this.receivedData == null) {
            return;
        }
        int chunkId = this.receivedData.readInt();
        int totalChunks = this.receivedData.readInt();
        if (totalChunks <= 0 || chunkId < 0 || chunkId >= totalChunks) {
            AELog.warn("Invalid chunked crafting tree packet received from server: Chunk %d/%d", chunkId, totalChunks);
            return;
        }
        if (totalChunks == 1) {
            PacketCraftingTreeData.onFullClientData(this.receivedData.slice().order(ByteOrder.LITTLE_ENDIAN), player);
        } else {
            ByteBuf[] storage;
            boolean packetComplete = false;
            WeakHashMap<EntityPlayer, ByteBuf[]> weakHashMap = chunkStorage;
            synchronized (weakHashMap) {
                storage = chunkStorage.get(player);
                if (storage == null || storage.length != totalChunks) {
                    storage = new ByteBuf[totalChunks];
                    chunkStorage.put(player, storage);
                }
                storage[chunkId] = this.receivedData.slice().order(ByteOrder.LITTLE_ENDIAN);
                if (Arrays.stream(storage).noneMatch(Objects::isNull)) {
                    chunkStorage.remove(player);
                    packetComplete = true;
                }
            }
            if (packetComplete) {
                ByteBuf combined = Unpooled.wrappedBuffer((ByteBuf[])storage).order(ByteOrder.LITTLE_ENDIAN);
                PacketCraftingTreeData.onFullClientData(combined, player);
            }
        }
    }

    private static void onFullClientData(ByteBuf data, EntityPlayer player) {
        CraftingJobV2 deserialized;
        ByteBuf decompressedData = Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN);
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(decompressedData);
             ByteBufInputStream bbis = new ByteBufInputStream(data);
             GZIPInputStream gzis = new GZIPInputStream((InputStream)bbis);){
            IOUtils.copy((InputStream)gzis, (OutputStream)bbos);
            bbos.flush();
        }
        catch (IOException e) {
            AELog.error(e, "Could not decompress the serialized crafting tree.");
            return;
        }
        try {
            deserialized = CraftingJobV2.deserialize(player.field_70170_p, decompressedData);
        }
        catch (Exception e) {
            AELog.error(e, "Could not deserialize crafting tree sent by the server.");
            return;
        }
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof GuiCraftConfirm) {
            ((GuiCraftConfirm)gs).setJobTree(deserialized);
        }
    }
}

