/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.packets.modules.QuickSortState;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleQuickSort
extends LogisticsGuiModule {
    protected final int stalledDelay = 24;
    protected final int normalDelay = 6;
    protected int currentTick = 0;
    protected boolean stalled;
    protected int lastStackLookedAt = 0;
    protected int lastSuceededStack = 0;
    private final PlayerCollectionList _watchingPlayer = new PlayerCollectionList();
    private int lastPosSend = 0;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        block29: {
            ItemStack tstack;
            IInventoryUtil invUtil;
            block28: {
                if (--this.currentTick > 0) {
                    return;
                }
                this.currentTick = this.stalled ? 24 : 6;
                invUtil = this._service.getPointedInventory(true);
                if (invUtil == null) {
                    return;
                }
                if (!this._service.canUseEnergy(500)) {
                    this.stalled = true;
                    return;
                }
                if (!(invUtil instanceof SpecialInventoryHandler)) break block28;
                Map<ItemIdentifier, Integer> items = invUtil.getItemsAndCount();
                if (this.lastSuceededStack >= items.size()) {
                    this.lastSuceededStack = 0;
                }
                if (this.lastStackLookedAt >= items.size()) {
                    this.lastStackLookedAt = 0;
                }
                int lookedAt = 0;
                for (Map.Entry<ItemIdentifier, Integer> item : items.entrySet()) {
                    if (++lookedAt <= this.lastStackLookedAt) continue;
                    LinkedList<Integer> jamList = new LinkedList<Integer>();
                    Pair<Integer, SinkReply> reply = this._service.hasDestination(item.getKey(), false, jamList);
                    if (reply == null) {
                        if (this.lastStackLookedAt == this.lastSuceededStack) {
                            this.stalled = true;
                        }
                        ++this.lastStackLookedAt;
                        return;
                    }
                    if (!this._service.useEnergy(500)) {
                        this.stalled = true;
                        ++this.lastStackLookedAt;
                        return;
                    }
                    this.stalled = false;
                    int maxItemsToSend = item.getKey().getMaxStackSize();
                    int availableItems = Math.min(maxItemsToSend, item.getValue());
                    while (reply != null) {
                        ItemStack stackToSend;
                        int count = availableItems;
                        if (reply.getValue2().maxNumberOfItems != 0) {
                            count = Math.min(count, reply.getValue2().maxNumberOfItems);
                        }
                        if ((stackToSend = invUtil.getMultipleItems(item.getKey(), count)) == null || stackToSend.field_77994_a == 0) break;
                        this._service.sendStack(stackToSend, reply, CoreRoutedPipe.ItemSendMode.Fast);
                        this._service.spawnParticle(Particles.OrangeParticle, 8);
                        if ((availableItems -= stackToSend.field_77994_a) <= 0) break;
                        jamList.add(reply.getValue1());
                        reply = this._service.hasDestination(item.getKey(), false, jamList);
                    }
                    if (availableItems > 0) {
                        this.lastSuceededStack = this.lastStackLookedAt++;
                    } else {
                        this.lastSuceededStack = this.lastStackLookedAt - 1;
                        if (this.lastSuceededStack < 0) {
                            this.lastSuceededStack = items.size() - 1;
                        }
                    }
                    return;
                }
                break block29;
            }
            if (!(invUtil instanceof SpecialInventoryHandler) && invUtil.getSizeInventory() == 0 || !this._service.canUseEnergy(500)) {
                this.stalled = true;
                return;
            }
            if (this.lastSuceededStack >= invUtil.getSizeInventory()) {
                this.lastSuceededStack = 0;
            }
            if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                this.lastStackLookedAt = 0;
            }
            ItemStack slot = invUtil.getStackInSlot(this.lastStackLookedAt);
            while (slot == null) {
                ++this.lastStackLookedAt;
                if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                    this.lastStackLookedAt = 0;
                }
                slot = invUtil.getStackInSlot(this.lastStackLookedAt);
                if (this.lastStackLookedAt != this.lastSuceededStack) continue;
                this.stalled = true;
                this.send();
                return;
            }
            this.send();
            LinkedList<Integer> jamList = new LinkedList<Integer>();
            Pair<Integer, SinkReply> reply = this._service.hasDestination(ItemIdentifier.get(slot), false, jamList);
            if (reply == null) {
                if (this.lastStackLookedAt == this.lastSuceededStack) {
                    this.stalled = true;
                }
                ++this.lastStackLookedAt;
                return;
            }
            if (!this._service.useEnergy(500)) {
                this.stalled = true;
                ++this.lastStackLookedAt;
                return;
            }
            this.stalled = false;
            slot = slot.func_77946_l();
            int sizePrev = slot.field_77994_a;
            boolean partialSend = false;
            while (reply != null) {
                int count = slot.field_77994_a;
                if (reply.getValue2().maxNumberOfItems > 0) {
                    count = Math.min(count, reply.getValue2().maxNumberOfItems);
                }
                ItemStack stackToSend = slot.func_77979_a(count);
                this._service.sendStack(stackToSend, reply, CoreRoutedPipe.ItemSendMode.Fast);
                this._service.spawnParticle(Particles.OrangeParticle, 8);
                if (slot.field_77994_a == 0) break;
                jamList.add(reply.getValue1());
                reply = this._service.hasDestination(ItemIdentifier.get(slot), false, jamList);
            }
            int amountToExtract = sizePrev - slot.field_77994_a;
            if (slot.field_77994_a > 0) {
                partialSend = true;
            }
            ItemStack returned = invUtil.decrStackSize(this.lastStackLookedAt, amountToExtract);
            if (returned.field_77994_a != amountToExtract) {
                throw new UnsupportedOperationException("Couldn't extract the already sended items from the inventory.");
            }
            this.lastSuceededStack = this.lastStackLookedAt++;
            if (!partialSend) break block29;
            if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                this.lastStackLookedAt = 0;
            }
            while (this.lastStackLookedAt != this.lastSuceededStack && ((tstack = invUtil.getStackInSlot(this.lastStackLookedAt)) == null || slot.func_77969_a(tstack))) {
                ++this.lastStackLookedAt;
                if (this.lastStackLookedAt < invUtil.getSizeInventory()) continue;
                this.lastStackLookedAt = 0;
            }
        }
    }

    protected void send() {
        if (this.lastPosSend != this.lastStackLookedAt) {
            this.lastPosSend = this.lastStackLookedAt;
            for (EntityPlayer player : this._watchingPlayer.players()) {
                this.sendPacketTo(player);
            }
        }
    }

    private void sendPacketTo(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(QuickSortState.class).setInteger2(this.lastPosSend).setInteger(this.getPositionInt()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleQuickSort");
    }

    public void addWatchingPlayer(EntityPlayer player) {
        this._watchingPlayer.add(player);
        this.sendPacketTo(player);
    }

    public void removeWatchingPlayer(EntityPlayer player) {
        this._watchingPlayer.remove(player);
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return null;
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return null;
    }
}

