/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.reference.RenderIDs;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.util.RenderUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RotatableBlockRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glPushMatrix();
        Tessellator t = Tessellator.field_78398_a;
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        t.func_78382_b();
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.WEST.ordinal(), 1));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.EAST.ordinal(), 1));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.NORTH.ordinal(), 1));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.SOUTH.ordinal(), 1));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.DOWN.ordinal(), 1));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.UP.ordinal(), 1));
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityFL)) {
            return false;
        }
        TileEntityFL l = (TileEntityFL)tileEntity;
        int i1 = l.getOrientation().ordinal();
        int c = l.getColor();
        switch (i1) {
            case 0: {
                renderer.field_147875_q = 3;
                renderer.field_147873_r = 3;
                renderer.field_147871_s = 3;
                renderer.field_147869_t = 3;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                renderer.field_147871_s = 1;
                renderer.field_147869_t = 2;
                break;
            }
            case 3: {
                renderer.field_147871_s = 2;
                renderer.field_147869_t = 1;
                renderer.field_147867_u = 3;
                renderer.field_147865_v = 3;
                break;
            }
            case 4: {
                renderer.field_147875_q = 1;
                renderer.field_147873_r = 2;
                renderer.field_147867_u = 2;
                renderer.field_147865_v = 1;
                break;
            }
            case 5: {
                renderer.field_147875_q = 2;
                renderer.field_147873_r = 1;
                renderer.field_147867_u = 1;
                renderer.field_147865_v = 2;
            }
        }
        if (c == 16) {
            renderer.func_147784_q(block, x, y, z);
        } else {
            float cMult = 1.0f;
            if (block == ModBlocks.blockCarbonLight) {
                cMult = 1.41531f;
            } else if (block == ModBlocks.blockElectricLight) {
                cMult = 1.2512f;
            } else if (block == ModBlocks.blockUVLight) {
                cMult = 1.273f;
            }
            renderer.func_147736_d(block, x, y, z, RenderUtil.r[c] * cMult, RenderUtil.g[c] * cMult, RenderUtil.b[c] * cMult);
        }
        renderer.field_147875_q = 0;
        renderer.field_147873_r = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
        return true;
    }

    public boolean shouldRender3DInInventory(int i) {
        return true;
    }

    public int getRenderId() {
        return RenderIDs.ROTATABLE_BLOCK;
    }
}

