/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ColorUtils {
    private static final int[] WOOL_TO_RGB = new int[]{0xFAFAFA, 14188339, 11685080, 6724056, 0xE5E533, 8375321, 15892389, 0x4C4C4C, 0x999999, 5013401, 8339378, 3361970, 6704179, 6717235, 0x993333, 0x191919};
    private static final String[] WOOL_TO_NAME = new String[]{"white", "orange", "magenta", "light.blue", "yellow", "lime", "pink", "gray", "light.gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String[] OREDICT_DYE_NAMES = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    private static final int[] OREDICT_DYE_IDS = new int[16];
    private static final char[] WOOL_TO_CHAT = new char[]{'f', '6', 'd', '9', 'e', 'a', 'd', '8', '7', '3', '5', '1', '6', '2', '4', '0'};

    private ColorUtils() {
    }

    public static void initialize() {
        for (int i = 0; i < 16; ++i) {
            ColorUtils.OREDICT_DYE_IDS[i] = OreDictionary.getOreID((String)OREDICT_DYE_NAMES[i]);
        }
    }

    public static int getColorIDFromDye(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return -1;
        }
        if (stack.func_77973_b() == Items.field_151100_aR) {
            return 15 - stack.func_77960_j();
        }
        int[] itemOreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (int i = 0; i < 16; ++i) {
            for (int id : itemOreIDs) {
                if (i != id) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        return ColorUtils.getColorIDFromDye(stack) >= 0;
    }

    public static int getRGBColor(int wool) {
        return WOOL_TO_RGB[wool & 0xF];
    }

    public static String getName(int wool) {
        return WOOL_TO_NAME[wool & 0xF];
    }

    public static String getOreDictionaryName(int wool) {
        return OREDICT_DYE_NAMES[wool & 0xF];
    }

    public static String getFormatting(int wool) {
        return "\u00a7" + WOOL_TO_CHAT[wool & 0xF];
    }

    public static String getFormattingTooltip(int wool) {
        return "\u00a7" + (WOOL_TO_CHAT[wool & 0xF] == '0' ? (char)'8' : WOOL_TO_CHAT[wool & 0xF]);
    }
}

