/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.infusionRecipe;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.glease.tc4tweak.api.infusionrecipe.RecipeIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;

public enum InfusionOreDictMode {
    Default{

        @Override
        public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
            int od = OreDictionary.getOreID((ItemStack)playerInput);
            if (od == -1) {
                return false;
            }
            ItemStack[] ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0]);
            return ThaumcraftApiHelper.containsMatch((boolean)false, (ItemStack[])new ItemStack[]{recipeSpec}, (ItemStack[])ores);
        }

        @Override
        public RecipeIngredient get(ItemStack recipeSpec) {
            int oreID = OreDictionary.getOreID((ItemStack)recipeSpec);
            if (oreID == -1) {
                return RecipeIngredient.item(false, recipeSpec);
            }
            return RecipeIngredient.oredict(OreDictionary.getOreName((int)oreID));
        }
    }
    ,
    Strict{

        @Override
        public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
            return new TIntHashSet(OreDictionary.getOreIDs((ItemStack)playerInput)).equals((Object)new TIntHashSet(OreDictionary.getOreIDs((ItemStack)recipeSpec)));
        }

        private List<ItemStack> intersect(List<ItemStack> all, List<ItemStack> stacks) {
            if (all.isEmpty() || stacks.isEmpty()) {
                all.clear();
                return Collections.emptyList();
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            block0: for (ItemStack stack : stacks) {
                for (ItemStack toMatch : all) {
                    if (!stack.func_77969_a(toMatch)) continue;
                    newStacks.add(stack);
                    continue block0;
                }
            }
            return newStacks;
        }

        @Override
        public RecipeIngredient get(ItemStack recipeSpec) {
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)recipeSpec);
            if (oreIDs.length == 0) {
                return RecipeIngredient.item(true, recipeSpec);
            }
            if (oreIDs.length == 1) {
                return RecipeIngredient.oredictStrict(OreDictionary.getOreName((int)oreIDs[0]));
            }
            List<Object> ores = null;
            for (int oreID : oreIDs) {
                ArrayList oresThis = OreDictionary.getOres((Integer)oreID);
                if (oresThis.size() == 1) {
                    return RecipeIngredient.item(true, recipeSpec);
                }
                if (ores == null) {
                    ores = new ArrayList(oresThis);
                    continue;
                }
                if ((ores = this.intersect((List<ItemStack>)ores, oresThis)).size() != 1) continue;
                return RecipeIngredient.item(true, recipeSpec);
            }
            return RecipeIngredient.items(false, ores.toArray(new ItemStack[0]));
        }
    }
    ,
    Relaxed{

        @Override
        public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
            TIntHashSet set = new TIntHashSet(OreDictionary.getOreIDs((ItemStack)playerInput));
            for (int i : OreDictionary.getOreIDs((ItemStack)recipeSpec)) {
                if (!set.contains(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RecipeIngredient get(ItemStack recipeSpec) {
            return Arrays.stream(OreDictionary.getOreIDs((ItemStack)recipeSpec)).mapToObj(OreDictionary::getOreName).map(RecipeIngredient::oredict).reduce(RecipeIngredient::or).orElseGet(() -> RecipeIngredient.item(false, recipeSpec));
        }
    }
    ,
    None{

        @Override
        public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
            return recipeSpec.func_77969_a(playerInput) && ItemStack.func_77970_a((ItemStack)recipeSpec, (ItemStack)playerInput);
        }

        @Override
        public RecipeIngredient get(ItemStack recipeSpec) {
            return RecipeIngredient.item(false, recipeSpec);
        }
    };


    public abstract boolean test(ItemStack var1, ItemStack var2);

    public abstract RecipeIngredient get(ItemStack var1);

    public static InfusionOreDictMode get(String name) {
        for (InfusionOreDictMode value : InfusionOreDictMode.values()) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        return Default;
    }
}

