/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.client.keybinds.control;

import com.cleanroommc.bogosorter.client.keybinds.KeyBind;
import com.cleanroommc.bogosorter.common.config.Serializer;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class BSKeybinds {
    public static final int MOUSE_LEFT = -100;
    public static final int MOUSE_RIGHT = -99;
    public static final int MOUSE_MIDDLE = -98;
    public static final KeyBinding sortKeyInGUI = new KeyBinding("key.sort_gui", -98, "key.categories.bogosorter");
    public static final KeyBinding sortKeyOutsideGUI = new KeyBinding("key.sort_nogui", 0, "key.categories.bogosorter");
    public static final KeyBinding configGuiKey = new KeyBinding("key.sort_config", 0, "key.categories.bogosorter");
    public static final KeyBinding dropoffKey = new KeyBinding("key.dropoff", 0, "key.categories.bogosorter");
    public static final KeyBinding BOGO_SORTER_CONTROLS_BUTTON = new KeyBinding("key.bogosorter.controls_button", 0, "key.categories.bogosorter");
    public static final KeybindDefinition MOVE_ALL_SAME = new KeybindDefinition("move_all_same", "key.bogosorter.move_all_same", -100, 56);
    public static final KeybindDefinition MOVE_ALL = new KeybindDefinition("move_all", "key.bogosorter.move_all", -100, 57);
    public static final KeybindDefinition MOVE_SINGLE = new KeybindDefinition("move_single", "key.bogosorter.move_single", -100, 29);
    public static final KeybindDefinition MOVE_SINGLE_EMPTY = new KeybindDefinition("move_single_empty", "key.bogosorter.move_single_empty", -99, 29);
    public static final KeybindDefinition THROW_ALL_SAME = new KeybindDefinition("throw_all_same", "key.bogosorter.throw_all_same", () -> BSKeybinds.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74316_C), 56);
    public static final KeybindDefinition THROW_ALL = new KeybindDefinition("throw_all", "key.bogosorter.throw_all", () -> BSKeybinds.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74316_C), 57);
    private static final Map<KeybindDefinition, List<Integer>> keyCombos = new HashMap<KeybindDefinition, List<Integer>>();
    private static final Map<KeybindDefinition, KeyBind> activeKeyBinds = new HashMap<KeybindDefinition, KeyBind>();
    private static final KeybindDefinition[] ALL_KEYBINDS = new KeybindDefinition[]{MOVE_ALL_SAME, MOVE_ALL, MOVE_SINGLE, MOVE_SINGLE_EMPTY, THROW_ALL_SAME, THROW_ALL};
    private static File configFile;

    public static void init(File suggestedConfigFile) {
        configFile = new File(suggestedConfigFile.getParentFile(), "bogosorter/keybinds.json");
        BSKeybinds.loadKeyCombos();
    }

    public static void rebuildKeyBinds() {
        activeKeyBinds.clear();
        for (Map.Entry<KeybindDefinition, List<Integer>> entry : keyCombos.entrySet()) {
            KeybindDefinition keySetting = entry.getKey();
            List<Integer> keys = entry.getValue();
            int[] keyCodes = keys.stream().mapToInt(i -> i).toArray();
            KeyBind.Builder builder = KeyBind.builder(keySetting.getName()).mustPress(keyCodes);
            if (keySetting.getValidator() != null) {
                builder.validator(keySetting.getValidator());
            }
            KeyBind keyBind = builder.build();
            activeKeyBinds.put(keySetting, keyBind);
        }
    }

    public static KeybindDefinition[] getAllKeybinds() {
        return ALL_KEYBINDS;
    }

    public static List<Integer> getKeyCombo(KeybindDefinition keybindDef) {
        return keyCombos.computeIfAbsent(keybindDef, k -> new ArrayList<Integer>(k.getDefaultKeyCodes()));
    }

    public static String getComboDisplayString(KeybindDefinition keybindDef) {
        List<Integer> combo = BSKeybinds.getKeyCombo(keybindDef);
        if (combo.isEmpty()) {
            return "NONE";
        }
        return combo.stream().map(keyCode -> {
            if (keyCode < 0) {
                switch (keyCode) {
                    case -100: {
                        return "LMB";
                    }
                    case -99: {
                        return "RMB";
                    }
                    case -98: {
                        return "MMB";
                    }
                }
                return "Mouse " + (keyCode + 100);
            }
            return Keyboard.getKeyName((int)keyCode);
        }).collect(Collectors.joining(" + "));
    }

    public static boolean isDefault(KeybindDefinition keybindDef) {
        return BSKeybinds.getKeyCombo(keybindDef).equals(keybindDef.getDefaultKeyCodes());
    }

    public static void resetToDefault(KeybindDefinition keybindDef) {
        keyCombos.put(keybindDef, new ArrayList<Integer>(keybindDef.getDefaultKeyCodes()));
        BSKeybinds.rebuildKeyBinds();
    }

    @Nullable
    public static KeyBind getActiveKeyBind(KeybindDefinition keybindDef) {
        return activeKeyBinds.get(keybindDef);
    }

    private static boolean isButtonPressed(int button) {
        return Mouse.getEventButtonState() && Mouse.getEventButton() == button;
    }

    private static boolean isKeyDown(KeyBinding key) {
        if (key.func_151463_i() == 0) {
            return false;
        }
        if (key.func_151463_i() < 0) {
            return BSKeybinds.isButtonPressed(key.func_151463_i() + 100);
        }
        return Keyboard.getEventKeyState() && Keyboard.getEventKey() == key.func_151463_i();
    }

    public static void loadKeyCombos() {
        if (configFile == null) {
            return;
        }
        Map loadedCombos = new HashMap();
        JsonElement jsonElement = Serializer.loadJson(configFile);
        if (jsonElement != null && jsonElement.isJsonObject()) {
            Type type = new TypeToken<Map<String, List<Integer>>>(){}.getType();
            loadedCombos = (Map)Serializer.gson.fromJson(jsonElement, type);
        }
        boolean needsSave = !configFile.exists();
        for (KeybindDefinition def : ALL_KEYBINDS) {
            List combo = (List)loadedCombos.get(def.getName());
            if (combo != null) {
                keyCombos.put(def, combo);
                continue;
            }
            keyCombos.put(def, new ArrayList<Integer>(def.getDefaultKeyCodes()));
            needsSave = true;
        }
        if (needsSave) {
            BSKeybinds.saveKeyCombos();
        }
        BSKeybinds.rebuildKeyBinds();
    }

    public static void saveKeyCombos() {
        if (configFile == null) {
            return;
        }
        HashMap<String, List<Integer>> dataToSave = new HashMap<String, List<Integer>>();
        for (Map.Entry<KeybindDefinition, List<Integer>> entry : keyCombos.entrySet()) {
            dataToSave.put(entry.getKey().getName(), entry.getValue());
        }
        JsonElement jsonElement = Serializer.gson.toJsonTree(dataToSave);
        Serializer.saveJson(configFile, jsonElement);
        BSKeybinds.rebuildKeyBinds();
    }

    public static class KeybindDefinition {
        private final String name;
        private final String unlocalizedName;
        private final List<Integer> defaultKeyCodes;
        private final BooleanSupplier validator;

        public KeybindDefinition(String name, String unlocalizedName, Integer ... defaultKeys) {
            this(name, unlocalizedName, (BooleanSupplier)null, defaultKeys);
        }

        public KeybindDefinition(String name, String unlocalizedName, BooleanSupplier validator, Integer ... defaultKeys) {
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.defaultKeyCodes = new ArrayList<Integer>(Arrays.asList(defaultKeys));
            this.validator = validator;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocalizedName, (Object[])new Object[0]);
        }

        public List<Integer> getDefaultKeyCodes() {
            return this.defaultKeyCodes;
        }

        public BooleanSupplier getValidator() {
            return this.validator;
        }
    }
}

