/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Arcade;

import vswe.stevescarts.Arcade.ArcadeGame;
import vswe.stevescarts.Arcade.ArcadeTracks;
import vswe.stevescarts.Arcade.Cart;
import vswe.stevescarts.Arcade.Track;
import vswe.stevescarts.Arcade.TrackOrientation;

public class TrackEnderHandler
extends Track {
    private boolean isSpawner;

    public TrackEnderHandler(int x, int y, TrackOrientation orientation, boolean isSpawner) {
        super(x, y, orientation);
        this.isSpawner = isSpawner;
    }

    @Override
    public void travel(ArcadeTracks game, Cart cart) {
        if (this.isSpawner) {
            game.getEnderman().setAlive(true);
            game.getEnderman().setDirection(TrackOrientation.DIRECTION.RIGHT);
            game.getEnderman().setX(cart.getX() + 5);
            game.getEnderman().setY(cart.getY());
        } else if (game.getEnderman().isAlive()) {
            game.getEnderman().setAlive(false);
        }
        ArcadeGame.playDefaultSound("mob.endermen.portal", 1.0f, 1.0f);
    }

    @Override
    public Track copy() {
        return new TrackEnderHandler(this.getX(), this.getY(), this.getOrientation(), this.isSpawner);
    }
}

