/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.widgets;

import mods.railcraft.common.gui.widgets.IndicatorController;

public class RFEnergyIndicator
extends IndicatorController {
    private int energy;
    private final int maxEnergy;

    public RFEnergyIndicator(int maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    @Override
    protected void refreshToolTip() {
        this.tip.text = String.format("%,d / %,d RF", this.energy, this.maxEnergy);
    }

    @Override
    public int getScaledLevel(int size) {
        double e = Math.min(this.energy, this.maxEnergy);
        return (int)(e * (double)size / (double)this.maxEnergy);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void updateEnergy(int energy) {
        this.energy = (int)((double)(this.energy * 9 + energy) / 10.0);
    }
}

