/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.BlockRailcraftFluid;
import mods.railcraft.common.fluids.BlockRailcraftFluidFinite;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum RailcraftFluids {
    CREOSOTE("fluid.creosote", Fluids.CREOSOTE, 800, 1500){

        @Override
        void defineContainers() {
            FluidContainers.getCreosoteOilBucket();
            FluidContainers.getCreosoteOilBottle();
            FluidContainers.getCreosoteOilCan();
            FluidContainers.getCreosoteOilCell();
            FluidContainers.getCreosoteOilWax();
            FluidContainers.getCreosoteOilRefactory();
        }

        @Override
        public Block makeBlock() {
            return new BlockRailcraftFluid(this.standardFluid.get(), Material.field_151586_h).setFlammable(true).setFlammability(10);
        }
    }
    ,
    STEAM("fluid.steam", Fluids.STEAM, -1000, 500){

        @Override
        void defineContainers() {
            FluidContainers.getSteamBottle();
        }

        @Override
        Block makeBlock() {
            return new BlockRailcraftFluidFinite(this.standardFluid.get(), (Material)new MaterialLiquid(MapColor.field_151660_b)).setNoFlow();
        }
    };

    public static final RailcraftFluids[] VALUES;
    public final String tag;
    public final Fluids standardFluid;
    public final int density;
    public final int viscosity;
    protected Fluid railcraftFluid;
    protected Block railcraftBlock;

    private RailcraftFluids(String tag, Fluids standardFluid, int density, int viscosity) {
        this.tag = tag;
        this.standardFluid = standardFluid;
        this.density = density;
        this.viscosity = viscosity;
    }

    public static void preInitFluids() {
        for (RailcraftFluids fluidType : VALUES) {
            fluidType.init();
        }
    }

    public static void postInitFluids() {
        for (RailcraftFluids fluidType : VALUES) {
            fluidType.postInit();
        }
    }

    public static Object getTextureHook() {
        return new TextureHook();
    }

    private void init() {
        this.initFluid();
        this.initBlock();
        this.checkStandardFluidBlock();
        if (this.standardFluid.get() != null) {
            this.defineContainers();
        }
    }

    private void postInit() {
        this.checkStandardFluidBlock();
        if (this.standardFluid.get() == null) {
            throw new MissingFluidException(this.standardFluid.getTag());
        }
    }

    private void initFluid() {
        if (this.railcraftFluid == null && RailcraftConfig.isFluidEnabled(this.standardFluid.getTag())) {
            this.railcraftFluid = new Fluid(this.standardFluid.getTag()).setDensity(this.density).setViscosity(this.viscosity).setGaseous(this.density < 0);
            FluidRegistry.registerFluid((Fluid)this.railcraftFluid);
        }
    }

    void defineContainers() {
    }

    abstract Block makeBlock();

    private void initBlock() {
        if (this.railcraftBlock == null && RailcraftConfig.isBlockEnabled(this.tag)) {
            this.railcraftBlock = this.makeBlock();
            this.railcraftBlock.func_149663_c("railcraft." + this.tag);
            RailcraftRegistry.register(this.railcraftBlock);
            this.railcraftFluid.setBlock(this.railcraftBlock);
        }
    }

    private void checkStandardFluidBlock() {
        if (this.railcraftBlock == null) {
            return;
        }
        Fluid fluid = this.standardFluid.get();
        if (fluid == null) {
            return;
        }
        Block fluidBlock = fluid.getBlock();
        if (fluidBlock == null) {
            fluid.setBlock(this.railcraftBlock);
        }
    }

    public Block getBlock() {
        return this.railcraftBlock;
    }

    static {
        VALUES = RailcraftFluids.values();
    }

    public static class TextureHook {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void textureHook(TextureStitchEvent.Post event) {
            if (event.map.func_130086_a() == 0) {
                for (RailcraftFluids fluidType : VALUES) {
                    if (fluidType.railcraftFluid == null) continue;
                    Block block = fluidType.railcraftBlock != null ? fluidType.railcraftBlock : fluidType.standardFluid.get().getBlock();
                    fluidType.railcraftFluid.setIcons(block.func_149733_h(1), block.func_149733_h(2));
                }
            }
        }
    }

    public static class MissingFluidException
    extends RuntimeException {
        public MissingFluidException(String tag) {
            super("Fluid '" + tag + "' was not found. Please check your configs.");
        }
    }
}

