/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.entity;

import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderRocket
extends Render {
    private final ResourceLocation texture;
    private final IModelCustom model;
    private final double offset;

    public RenderRocket(int tier, double offset) {
        this.texture = new ResourceLocation("galaxyspace", "textures/model/tier" + tier + "rocket.png");
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier" + tier + "rocket.obj"));
        this.offset = offset;
        this.field_76989_e = 2.0f;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        EntitySpaceshipBase rocket = (EntitySpaceshipBase)entity;
        GL11.glDisable((int)32826);
        GL11.glPushMatrix();
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTickTime + 180.0f;
        GL11.glTranslated((double)x, (double)(y - this.offset), (double)z);
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        float roll = rocket.rollAmplitude / 3.0f - partialTickTime;
        if (roll > 0.0f) {
            float i = rocket.getLaunched() ? (float)(5 - MathHelper.func_76128_c((double)(rocket.timeUntilLaunch / 85))) * 0.1f : 0.3f;
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)roll) * roll * i * partialTickTime), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)roll) * roll * i * partialTickTime), (float)1.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glScalef((float)0.9f, (float)0.9f, (float)0.9f);
        this.func_110776_a(this.texture);
        this.model.renderAll();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.texture;
    }
}

