/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.client.gui.widget.GuiText;
import gcewing.architecture.common.item.ArchitectureItemBlock;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Vec3i;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.util.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShapeItem
extends ArchitectureItemBlock {
    static Random rand = new Random();

    public ShapeItem(Block block) {
        super(block);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!BlockCompatUtils.setWorldBlockState(world, pos, newState, 3)) {
            return false;
        }
        Vec3i d = Vector3.getDirectionVec(face);
        Vector3 hit = new Vector3((double)(hitX - (float)d.getX()) - 0.5, (double)(hitY - (float)d.getY()) - 0.5, (double)(hitZ - (float)d.getZ()) - 0.5);
        TileShape te = TileShape.get((IBlockAccess)world, pos);
        if (te != null) {
            te.readFromItemStack(stack);
            if (te.shape != null) {
                BlockPos npos = te.getPos().offset(Utils.oppositeFacing(face));
                IBlockState nstate = BlockCompatUtils.getWorldBlockState((IBlockAccess)world, npos);
                TileEntity nte = BlockCompatUtils.getWorldTileEntity((IBlockAccess)world, npos);
                te.shape.orientOnPlacement(player, te, npos, nstate, nte, face, hit);
            }
        }
        return true;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean par4) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            int id = tag.func_74762_e("Shape");
            Shape shape = Shape.forId(id);
            if (shape != null) {
                lines.set(0, GuiText.valueOf(GuiText.class, shape.name()).getLocal());
            } else {
                lines.set(0, lines.get(0) + " (" + id + ")");
            }
            Block baseBlock = Block.func_149684_b((String)tag.func_74779_i("BaseName"));
            int baseMetadata = tag.func_74762_e("BaseData");
            if (baseBlock != null) {
                lines.add(Utils.displayNameOfBlock(baseBlock, baseMetadata));
            }
        }
    }
}

