/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal;

import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.math.Color;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public class Theme {
    public static final Theme INSTANCE = new Theme();
    public static final String KEY_BACKGROUND = "bg";
    public static final String KEY_BUTTON = "button";
    public static final String KEY_TEXT = "text";
    public static final String KEY_ITEM_SLOT = "itemslot";
    public static final String KEY_FLUID_SLOT = "fluidslot";
    public static final String KEY_SLOT_HIGHLIGHT = "slothighlight";
    private final HashMap<String, Integer> colors = new HashMap(32);

    private Theme() {
        this.registerThemeColor(KEY_BACKGROUND);
        this.registerThemeColor(KEY_BUTTON);
        this.registerThemeColor(KEY_TEXT, 0x404040);
        this.registerThemeColor(KEY_ITEM_SLOT);
        this.registerThemeColor(KEY_FLUID_SLOT);
        this.registerThemeColor(KEY_SLOT_HIGHLIGHT, Color.withAlpha(Color.WHITE.normal, 128));
    }

    public void registerThemeColor(String name) {
        this.registerThemeColor(name, -1);
    }

    public void registerThemeColor(String name, int value) {
        if (this.colors.containsKey(name)) {
            ModularUI.logger.error("Theme already has a color with key {}", new Object[]{name});
            return;
        }
        this.colors.put(name, value);
    }

    public int getColor(@Nullable String key) {
        return key == null ? -1 : this.colors.getOrDefault(key, -1);
    }

    public int getBackground() {
        return this.getColor(KEY_BACKGROUND);
    }

    public int getButton() {
        return this.getColor(KEY_BUTTON);
    }

    public int getText() {
        return this.getColor(KEY_TEXT);
    }

    public int getItemSlot() {
        return this.getColor(KEY_ITEM_SLOT);
    }

    public int getFluidSlot() {
        return this.getColor(KEY_FLUID_SLOT);
    }

    public int getSlotHighlight() {
        return this.getColor(KEY_SLOT_HIGHLIGHT);
    }

    public JsonObject readTheme(JsonObject json) {
        for (String key : this.colors.keySet()) {
            if (json.has(key)) {
                this.colors.put(key, json.get(key).getAsInt());
                continue;
            }
            json.addProperty(key, (Number)this.colors.get(key));
        }
        return json;
    }
}

