/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.oiltweak;

import buildcraft.oiltweak.BuildCraftOilTweak;
import buildcraft.oiltweak.OilTweakProperties;
import buildcraft.oiltweak.api.OilTweakAPI;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class OilTweakEventHandler {
    protected InOil getInOil(Entity entity) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72340_a + 0.001));
        if (entity.field_70170_p.func_72904_c(minX, minY = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72338_b + 0.001)), minZ = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72339_c + 0.001)), maxX = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72336_d - 0.001)), maxY = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72337_e - 0.001)), maxZ = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72334_f - 0.001)))) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!this.isOil(entity.field_70170_p.func_147439_a(x, y, z))) continue;
                        return maxY == minY || this.isOil(entity.field_70170_p.func_147439_a(x, maxY, z)) ? InOil.FULL : InOil.HALF;
                    }
                }
            }
        }
        return InOil.NONE;
    }

    private boolean isOil(Block block) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        return fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid) && fluid.getName() != null && fluid.getName().equalsIgnoreCase("oil");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerUpdate(TickEvent.PlayerTickEvent e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityPlayer player = e.player;
        if (!this.getInOil((Entity)player).halfOfFull()) {
            this.setNotInOil((EntityLivingBase)player);
            return;
        }
        player.field_70181_x = Math.min(0.0, player.field_70181_x);
        if (player.field_70181_x < -0.05) {
            player.field_70181_x *= 0.05;
        }
        player.field_70159_w = Math.max(-0.05, Math.min(0.05, player.field_70159_w * 0.05));
        player.field_70181_x -= 0.05;
        player.field_70179_y = Math.max(-0.05, Math.min(0.05, player.field_70179_y * 0.05));
        player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
        this.setStepHeight((EntityLivingBase)player, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerClientUpdate(TickEvent.ClientTickEvent e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!this.getInOil((Entity)player).halfOfFull()) {
            this.setNotInOil((EntityLivingBase)player);
            return;
        }
        player.field_70181_x = Math.min(0.0, player.field_70181_x);
        if (player.field_70181_x < -0.05) {
            player.field_70181_x *= 0.05;
        }
        player.field_70159_w = Math.max(-0.05, Math.min(0.05, player.field_70159_w * 0.05));
        player.field_70181_x -= 0.05;
        player.field_70179_y = Math.max(-0.05, Math.min(0.05, player.field_70179_y * 0.05));
        player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
        this.setStepHeight((EntityLivingBase)player, 0.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityLivingBase entity = e.entityLiving;
        if (!this.getInOil((Entity)entity).halfOfFull()) {
            this.setNotInOil(entity);
            return;
        }
        entity.field_70181_x = Math.min(0.0, entity.field_70181_x);
        if (entity.field_70181_x < -0.05) {
            entity.field_70181_x *= 0.05;
        }
        entity.field_70159_w = Math.max(-0.05, Math.min(0.05, entity.field_70159_w * 0.05));
        entity.field_70181_x -= 0.05;
        entity.field_70179_y = Math.max(-0.05, Math.min(0.05, entity.field_70179_y * 0.05));
        this.setStepHeight(entity, 0.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityPlayer player = e.entityPlayer;
        if (this.getInOil((Entity)player).halfOfFull()) {
            e.newSpeed = e.originalSpeed <= e.newSpeed ? e.originalSpeed / 3.0f : e.newSpeed / 3.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTeleportAttempt(EnderTeleportEvent e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityLivingBase player = e.entityLiving;
        if (!(player instanceof EntityPlayer && ((EntityPlayer)player).field_71075_bZ.field_75098_d || !this.getInOil((Entity)player).halfOfFull())) {
            e.setCanceled(true);
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClick(PlayerInteractEvent e) {
        InOil inOil;
        if (e.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK || !BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityPlayer player = e.entityPlayer;
        if (!player.field_71075_bZ.field_75098_d && player.func_71045_bC() != null && (inOil = this.getInOil((Entity)player)).halfOfFull() && (inOil == InOil.FULL && !(player.func_71045_bC().func_77973_b() instanceof ItemBlock) || OilTweakAPI.INSTANCE.getItemBlacklistRegistry().isBlacklisted((EntityLivingBase)player, player.func_71045_bC()))) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(inOil == InOil.FULL ? "oiltweak.chat.tooDense.use" : "oiltweak.chat.tooDense.use.half", new Object[0]));
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing e) {
        if (e.entity instanceof EntityLivingBase) {
            e.entity.registerExtendedProperties("oiltweak", (IExtendedEntityProperties)new OilTweakProperties());
        }
    }

    private OilTweakProperties getProperties(EntityLivingBase entity) {
        IExtendedEntityProperties ieep = entity.getExtendedProperties("oiltweak");
        if (ieep == null || !(ieep instanceof OilTweakProperties)) {
            ieep = new OilTweakProperties();
            ieep.init((Entity)entity, entity.field_70170_p);
            entity.registerExtendedProperties("oiltweak", ieep);
        }
        return (OilTweakProperties)ieep;
    }

    private void setStepHeight(EntityLivingBase entity, float height) {
        OilTweakProperties props = this.getProperties(entity);
        if (!props.inOil) {
            props.realStepHeight = entity.field_70138_W;
            props.inOil = true;
        }
        entity.field_70138_W = height;
    }

    private void setNotInOil(EntityLivingBase entity) {
        OilTweakProperties props = this.getProperties(entity);
        if (!props.inOil) {
            return;
        }
        entity.field_70138_W = props.realStepHeight;
        props.inOil = false;
    }

    private static enum InOil {
        NONE,
        HALF,
        FULL;


        public boolean halfOfFull() {
            return this != NONE;
        }
    }
}

