/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei.arcaneworkbench;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.ArcaneShapedRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.nei.ResearchInfo;
import ru.timeconqueror.tcneiadditions.nei.arcaneworkbench.IArcaneOverlayProvider;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ArcaneCraftingShapedHandler
extends ArcaneShapedRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private int ySizeNormal;
    private int ySizeRod;
    private int ySizeCap;
    private TCNAClient tcnaClient = TCNAClient.getInstance();

    public void loadTransferRects() {
        TCUtil.loadTransferRects((TemplateRecipeHandler)this);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                ArcaneWandCachedRecipe wandRec = null;
                if (!(o instanceof ShapedArcaneRecipe)) continue;
                ShapedArcaneRecipe tcRecipe = (ShapedArcaneRecipe)o;
                Item item = tcRecipe.getRecipeOutput().func_77973_b();
                if (item instanceof ItemWandCasting) {
                    ItemWandCasting wand = (ItemWandCasting)item;
                    WandRod rod = wand.getRod(tcRecipe.getRecipeOutput());
                    WandCap cap = wand.getCap(tcRecipe.getRecipeOutput());
                    boolean shouldShowRecipe = false;
                    if ((!wand.isSceptre(tcRecipe.getRecipeOutput()) || TCUtil.shouldShowRecipe(this.userName, "SCEPTRE")) && TCUtil.shouldShowRecipe(this.userName, cap.getResearch()) && TCUtil.shouldShowRecipe(this.userName, rod.getResearch())) {
                        shouldShowRecipe = true;
                    }
                    if (rod != null || cap != null) {
                        wandRec = new ArcaneWandCachedRecipe(rod, cap, tcRecipe.getRecipeOutput(), false, shouldShowRecipe);
                    }
                }
                boolean shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch());
                ArcaneShapedCachedRecipe recipe = new ArcaneShapedCachedRecipe(tcRecipe, shouldShowRecipe);
                if (wandRec != null) {
                    recipe.prereqs.addAll(wandRec.prereqs);
                }
                if (!recipe.isValid()) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)tcRecipe));
            }
        } else if (outputId.equals("item")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)result.func_77973_b();
            WandRod rod = wand.getRod(result);
            WandCap cap = wand.getCap(result);
            boolean shouldShowRecipe = false;
            if ((!wand.isSceptre(result) || TCUtil.shouldShowRecipe(this.userName, "SCEPTRE")) && TCUtil.shouldShowRecipe(this.userName, cap.getResearch()) && TCUtil.shouldShowRecipe(this.userName, rod.getResearch())) {
                shouldShowRecipe = true;
            }
            if (!TCNAClient.getInstance().areWandRecipesDeleted()) {
                ArcaneWandCachedRecipe recipe = new ArcaneWandCachedRecipe(rod, cap, result, wand.isSceptre(result), shouldShowRecipe);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(NEIHelper.getWandAspectsWandCost((ItemStack)result));
            }
            this.loadShapedRecipesForWands(result, shouldShowRecipe);
        } else {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                ShapedArcaneRecipe shapedArcaneRecipe;
                ArcaneShapedCachedRecipe recipe;
                if (!(o instanceof ShapedArcaneRecipe) || !(recipe = new ArcaneShapedCachedRecipe(shapedArcaneRecipe = (ShapedArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, shapedArcaneRecipe.getResearch()))).isValid() || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)shapedArcaneRecipe.getRecipeOutput(), (ItemStack)result)) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)shapedArcaneRecipe));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapedArcaneRecipe tcRecipe;
            ArcaneShapedCachedRecipe recipe;
            if (!(o instanceof ShapedArcaneRecipe) || !(recipe = new ArcaneShapedCachedRecipe(tcRecipe = (ShapedArcaneRecipe)o, true)).isValid() || !recipe.containsWithNBT(recipe.ingredients, ingredient) || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch())) continue;
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)tcRecipe));
        }
    }

    public void loadShapedRecipesForWands(ItemStack wandStack, boolean shouldShowRecipe) {
        if (!(wandStack.func_77973_b() instanceof ItemWandCasting)) {
            throw new RuntimeException("This method works only for Thaumcraft Wands! Provided: " + wandStack);
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        WandRod rod = wand.getRod(wandStack);
        WandCap cap = wand.getCap(wandStack);
        boolean isSceptre = wand.isSceptre(wandStack);
        ThaumcraftApi.getCraftingRecipes().stream().filter(o -> o instanceof ShapedArcaneRecipe).filter(r -> {
            ItemStack output = ((ShapedArcaneRecipe)r).output;
            if (!(output.func_77973_b() instanceof ItemWandCasting)) {
                return false;
            }
            if (isSceptre != wand.isSceptre(output)) {
                return false;
            }
            if (output.func_77973_b().getClass() != wandStack.func_77973_b().getClass()) {
                return false;
            }
            WandRod outputRod = wand.getRod(output);
            WandCap outputCap = wand.getCap(output);
            return outputRod.getTag().equals(rod.getTag()) && outputCap.getTag().equals(cap.getTag());
        }).forEach(o -> {
            ShapedArcaneRecipe arcaneRecipe = (ShapedArcaneRecipe)o;
            ArcaneShapedCachedRecipe recipe = new ArcaneShapedCachedRecipe(arcaneRecipe, shouldShowRecipe);
            ArcaneWandCachedRecipe wandRec = new ArcaneWandCachedRecipe(rod, cap, wandStack, false, shouldShowRecipe);
            recipe.prereqs.addAll(wandRec.prereqs);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)arcaneRecipe));
        });
    }

    public void drawBackground(int recipeIndex) {
        boolean shouldShowRecipe;
        ShapedRecipeHandler.CachedShapedRecipe recipe;
        TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (cRecipe instanceof ArcaneShapedCachedRecipe) {
            recipe = (ArcaneShapedCachedRecipe)cRecipe;
            shouldShowRecipe = ((ArcaneShapedCachedRecipe)recipe).shouldShowRecipe;
        } else if (cRecipe instanceof ArcaneWandCachedRecipe) {
            recipe = (ArcaneWandCachedRecipe)cRecipe;
            shouldShowRecipe = ((ArcaneWandCachedRecipe)recipe).shouldShowRecipe;
        } else {
            throw new RuntimeException("Incompatible recipe type found: " + cRecipe.getClass());
        }
        int x = 34;
        int y = -15;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)20, (int)7, (int)20, (int)3, (int)16, (int)16);
        if (shouldShowRecipe) {
            GuiDraw.drawTexturedModalRect((int)2, (int)23, (int)112, (int)15, (int)52, (int)52);
        }
        GL11.glPopMatrix();
        if (shouldShowRecipe) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GL11.glEnable((int)3042);
            GL11.glTranslatef((float)((float)x - 30.0f), (float)(y + 126), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)68, (int)76, (int)12, (int)12);
            GL11.glPopMatrix();
            this.drawAspects(recipeIndex);
        }
    }

    public void drawAspects(int recipe) {
        int[] amounts = (int[])this.aspectsAmount.get(recipe);
        AspectList aspects = NEIHelper.getPrimalAspectListFromAmounts((int[])amounts);
        int baseX = 36;
        int baseY = 115;
        int count = 0;
        int columns = aspects.size();
        int xOffset = (100 - columns * 20) / 2;
        for (int column = 0; column < columns; ++column) {
            Aspect aspect = aspects.getAspectsSortedAmount()[count++];
            int posX = baseX + column * 18 + xOffset;
            UtilsFX.drawTag((int)posX, (int)baseY, (Aspect)aspect, (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
        }
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        return recipe instanceof IArcaneOverlayProvider ? ((IArcaneOverlayProvider)recipe).getPositionedStacksForOverlay() : null;
    }

    public void drawExtras(int recipeIndex) {
        ArcaneWandCachedRecipe cachedRecipe;
        int y;
        String textToDraw;
        ArcaneShapedCachedRecipe cachedRecipe2;
        TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (cRecipe instanceof ArcaneShapedCachedRecipe) {
            cachedRecipe2 = (ArcaneShapedCachedRecipe)cRecipe;
            if (!cachedRecipe2.shouldShowRecipe) {
                textToDraw = StatCollector.func_74838_a((String)"tcneiadditions.research.missing");
                y = 28;
                for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                    GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
                    y += 11;
                }
            }
        } else if (cRecipe instanceof ArcaneWandCachedRecipe && !(cachedRecipe = (ArcaneWandCachedRecipe)cRecipe).shouldShowRecipe) {
            textToDraw = StatCollector.func_74838_a((String)"tcneiadditions.research.missing");
            y = 28;
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"tcneiadditions.research.researchName")), (int)0, (int)5, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
            if (cRecipe instanceof ArcaneShapedCachedRecipe) {
                cachedRecipe2 = (ArcaneShapedCachedRecipe)cRecipe;
                int recipeY = 15;
                for (ResearchInfo r : cachedRecipe2.prereqs) {
                    r.onDraw(0, recipeY);
                    recipeY += 13;
                }
            } else if (cRecipe instanceof ArcaneWandCachedRecipe) {
                cachedRecipe = (ArcaneWandCachedRecipe)cRecipe;
                int recipeY = 15;
                for (ResearchInfo r : cachedRecipe.prereqs) {
                    r.onDraw(0, recipeY);
                    recipeY += 13;
                }
            }
        }
        TCUtil.drawSeeAllRecipesLabel();
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> list, int recipeIndex) {
        block2: {
            Point mousePos;
            TemplateRecipeHandler.CachedRecipe cRecipe;
            block3: {
                if (!TCNAConfig.showResearchKey || !GuiContainerManager.shouldShowTooltip(gui) || !list.isEmpty()) break block2;
                cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
                mousePos = GuiDraw.getMousePosition();
                if (!(cRecipe instanceof ArcaneShapedCachedRecipe)) break block3;
                ArcaneShapedCachedRecipe cachedRecipe = (ArcaneShapedCachedRecipe)cRecipe;
                for (ResearchInfo r : cachedRecipe.prereqs) {
                    Rectangle rect = r.getRect(gui, recipeIndex);
                    if (!rect.contains(mousePos)) continue;
                    r.onHover(list);
                }
                break block2;
            }
            if (!(cRecipe instanceof ArcaneWandCachedRecipe)) break block2;
            ArcaneWandCachedRecipe cachedRecipe = (ArcaneWandCachedRecipe)cRecipe;
            for (ResearchInfo r : cachedRecipe.prereqs) {
                Rectangle rect = r.getRect(gui, recipeIndex);
                if (!rect.contains(mousePos)) continue;
                r.onHover(list);
            }
        }
        return super.handleTooltip(gui, list, recipeIndex);
    }

    private class ArcaneWandCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe
    implements IArcaneOverlayProvider {
        protected AspectList aspects;
        protected Object[] overlay;
        protected final List<ResearchInfo> prereqs;
        private final boolean shouldShowRecipe;

        public ArcaneWandCachedRecipe(WandRod rod, WandCap cap, ItemStack result, boolean isScepter, boolean shouldShowRecipe) {
            super((ShapedRecipeHandler)ArcaneCraftingShapedHandler.this, 3, 3, isScepter ? NEIHelper.buildScepterInput((WandRod)rod, (WandCap)cap) : NEIHelper.buildWandInput((WandRod)rod, (WandCap)cap), result);
            this.overlay = isScepter ? NEIHelper.buildScepterInput((WandRod)rod, (WandCap)cap) : NEIHelper.buildWandInput((WandRod)rod, (WandCap)cap);
            this.result = new PositionedStack((Object)result, 74, 2);
            this.aspects = NEIHelper.getPrimalAspectListFromAmounts((int[])NEIHelper.getWandAspectsWandCost((ItemStack)result));
            this.shouldShowRecipe = shouldShowRecipe;
            this.prereqs = new ArrayList<ResearchInfo>();
            if (isScepter) {
                this.prereqs.add(new ResearchInfo(ResearchCategories.getResearch((String)"SCEPTRE"), ThaumcraftApiHelper.isResearchComplete((String)ArcaneCraftingShapedHandler.this.userName, (String)"SCEPTRE")));
            }
            if (cap != null && !cap.getResearch().isEmpty()) {
                this.prereqs.add(new ResearchInfo(ResearchCategories.getResearch((String)cap.getResearch()), ThaumcraftApiHelper.isResearchComplete((String)ArcaneCraftingShapedHandler.this.userName, (String)cap.getResearch())));
            }
            if (rod != null && !rod.getResearch().isEmpty()) {
                this.prereqs.add(new ResearchInfo(ResearchCategories.getResearch((String)rod.getResearch()), ThaumcraftApiHelper.isResearchComplete((String)ArcaneCraftingShapedHandler.this.userName, (String)rod.getResearch())));
            }
            this.addAspectsToIngredients(this.aspects);
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return super.getIngredients();
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int[][] positions2 = new int[][]{{48, 32}, {75, 33}, {49, 60}, {76, 60}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        Object object = items[y * width + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && !(object instanceof List) || object instanceof List && ((List)object).isEmpty()) continue;
                        if (width == 2 && height == 2) {
                            positions = positions2;
                        }
                        PositionedStack stack = new PositionedStack(object, positions[y * width + x][0] + shiftX, positions[y * width + x][1] + shiftY, object instanceof ItemStack);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
                return this.aspects.aspects.containsKey(aspect);
            }
            return super.contains(ingredients, ingredient);
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        Object object = this.overlay[y * 3 + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                        stacks.add(new PositionedStack(object, 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int baseX = 36;
            int baseY = 115;
            int count = 0;
            int columns = aspects.size();
            int xOffset = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = baseX + column * 18 + xOffset;
                ItemStack stack = new ItemStack(ModItems.itemAspect, aspects.getAmount(aspect), 1);
                ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                this.ingredients.add(new PositionedStack((Object)stack, posX, baseY, false));
            }
        }
    }

    private class ArcaneShapedCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe
    implements IArcaneOverlayProvider {
        protected AspectList aspects;
        protected Object[] overlay;
        protected final List<ResearchInfo> prereqs;
        protected int width;
        protected int height;
        private final boolean shouldShowRecipe;
        private final ResearchItem researchItem;

        public ArcaneShapedCachedRecipe(ShapedArcaneRecipe recipe, boolean shouldShowRecipe) {
            super((ShapedRecipeHandler)ArcaneCraftingShapedHandler.this, recipe.width, recipe.height, recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.aspects = recipe.getAspects();
            this.overlay = recipe.getInput();
            this.width = recipe.width;
            this.height = recipe.height;
            this.shouldShowRecipe = shouldShowRecipe;
            this.researchItem = ResearchCategories.getResearch((String)recipe.getResearch());
            this.prereqs = new ArrayList<ResearchInfo>();
            if (this.researchItem != null && this.researchItem.key != null) {
                this.prereqs.add(new ResearchInfo(this.researchItem, ThaumcraftApiHelper.isResearchComplete((String)ArcaneCraftingShapedHandler.this.userName, (String)this.researchItem.key)));
            }
            this.addAspectsToIngredients(this.aspects);
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int y;
                int x;
                int[][][] positions2 = new int[width][height][2];
                int shiftX = 0;
                int shiftY = 0;
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        positions2[x][y][0] = ArcaneShapedRecipeHandler.positions[y][x][0];
                        positions2[x][y][1] = ArcaneShapedRecipeHandler.positions[y][x][1];
                    }
                }
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        if (items[y * width + x] == null || !(items[y * width + x] instanceof ItemStack) && !(items[y * width + x] instanceof ItemStack[]) && !(items[y * width + x] instanceof String) && !(items[y * width + x] instanceof List) || items[y * width + x] instanceof List && ((List)items[y * width + x]).isEmpty()) continue;
                        PositionedStack stack = new PositionedStack(items[y * width + x], positions2[x][y][0] + shiftX, positions2[x][y][1] + shiftY, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return super.getIngredients();
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
                return this.aspects.aspects.containsKey(aspect);
            }
            return super.contains(ingredients, ingredient);
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        Object object = this.overlay[y * this.width + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                        stacks.add(new PositionedStack(object, 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int baseX = 36;
            int baseY = 115;
            int count = 0;
            int columns = aspects.size();
            int xOffset = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = baseX + column * 18 + xOffset;
                ItemStack stack = new ItemStack(ModItems.itemAspect, aspects.getAmount(aspect), 1);
                ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                this.ingredients.add(new PositionedStack((Object)stack, posX, baseY, false));
            }
        }
    }
}

