/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.CustomRenderBlocks;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.render.IModel;
import crazypants.enderio.machine.transceiver.render.TransceiverModel;
import crazypants.enderio.machine.transceiver.render.TransceiverModelAlt;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TransceiverRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private IModel model;
    private BoundingBox bb;
    private boolean adjustForItem = false;

    public TransceiverRenderer() {
        float scale = 0.7f;
        if (Config.useAlternateTesseractModel) {
            this.model = new TransceiverModelAlt();
            scale = 0.8f;
            this.adjustForItem = true;
        } else {
            this.model = new TransceiverModel();
        }
        this.bb = BoundingBox.UNIT_CUBE.scale(scale, scale, scale);
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float tick) {
        TileTransceiver trans = (TileTransceiver)te;
        GL11.glEnable((int)32826);
        float f = trans.func_145831_w().func_72957_l(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        int l = trans.func_145831_w().func_72802_i(te.field_145851_c, te.field_145848_d, te.field_145849_e, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.field_78398_a.func_78386_a(f, f, f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        this.model.render(trans, x, y, z);
        if (trans.isActive()) {
            this.renderPower(te.func_145831_w(), x, y, z, true);
        }
        GL11.glDisable((int)32826);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78386_a(f, f, f);
        RenderUtil.bindBlockTexture();
        CustomRenderBlocks rb = new CustomRenderBlocks((IBlockAccess)te.func_145831_w());
        double scale = 0.88;
        BoundingBox pushPullBounds = BoundingBox.UNIT_CUBE.scale(scale, scale, scale);
        BoundingBox disabledBounds = BoundingBox.UNIT_CUBE.scale(1.01, 1.01, 1.01);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IoMode mode = trans.getIoMode(dir);
            if (mode == null) continue;
            if (mode == IoMode.DISABLED) {
                rb.func_147782_a((double)disabledBounds.minX, (double)disabledBounds.minY, (double)disabledBounds.minZ, (double)disabledBounds.maxX, (double)disabledBounds.maxY, (double)disabledBounds.maxZ);
            } else {
                rb.func_147782_a((double)pushPullBounds.minX, (double)pushPullBounds.minY, (double)pushPullBounds.minZ, (double)pushPullBounds.maxX, (double)pushPullBounds.maxY, (double)pushPullBounds.maxZ);
            }
            IIcon icon = EnderIO.blockTransceiver.getOverlayIconForMode(trans, dir, mode);
            if (icon == null) continue;
            rb.doDefaultRenderFace(dir, (Block)EnderIO.blockTransceiver, 0.0, 0.0, 0.0, icon);
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.adjustForItem) {
            switch (type) {
                case ENTITY: {
                    this.renderItem(0.0f, 0.0f, 0.0f);
                    return;
                }
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: {
                    this.renderItem(0.0f, 1.0f, 1.0f);
                    return;
                }
                case INVENTORY: {
                    this.renderItem(0.0f, 0.0f, 0.0f);
                    return;
                }
            }
            this.renderItem(0.0f, 0.0f, 0.0f);
            return;
        }
        this.renderItem(0.0f, 0.0f, 0.0f);
    }

    private void renderPower(World world, double x, double y, double z, boolean isActive) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        RenderUtil.bindBlockTexture();
        IIcon icon = EnderIO.blockHyperCube.getPortalIcon();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (!isActive) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        CubeRenderer.get().render(this.bb, icon);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void renderItem(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        this.model.render();
        GL11.glPopMatrix();
    }
}

