/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.common.WirelessDataStore;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.util.CommonValues;

public class MTEHatchWirelessDataItemsInput
extends MTEHatchDataAccess {
    private List<GTRecipe.RecipeAssemblyLine> recipes = null;

    public MTEHatchWirelessDataItemsInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchWirelessDataItemsInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessDataItemsInput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(MTEHatchDataConnector.EM_D_ACTIVE, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(MTEHatchDataConnector.EM_D_SIDES, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        return null;
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainasswireless.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainasswireless.desc.1")};
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (aTick = (long)MinecraftServer.func_71276_C().func_71259_af()) % 200L == 1L) {
            WirelessDataStore wirelessDataStore = WirelessDataStore.getWirelessDataSticks(this.getBaseMetaTileEntity().getOwnerUuid());
            this.recipes = wirelessDataStore.downloadData(aTick);
        }
    }

    @Override
    public List<GTRecipe.RecipeAssemblyLine> getAssemblyLineRecipes() {
        if (this.recipes == null) {
            return Collections.emptyList();
        }
        return this.recipes;
    }

    @Override
    protected String getWailaDataI18nKey() {
        return "tt.keyphrase.AL_Recipe_Receiving";
    }
}

