/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock.eigbuckets;

import java.util.ArrayList;
import java.util.Random;
import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.eig.IEIGBucketFactory;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tb.common.block.BlockRainbowCactus;
import tb.init.TBBlocks;

public class EIGRainbowCactusBucket
extends EIGBucket {
    public static final IEIGBucketFactory factory = new Factory();
    private static final String NBT_IDENTIFIER = "TB:RAINCACTI";
    private static final int REVISION_NUMBER = 0;
    private final Random random = new Random();

    public EIGRainbowCactusBucket(ItemStack seed, int seedCount) {
        super(seed, seedCount, null);
    }

    public EIGRainbowCactusBucket(NBTTagCompound nbt) {
        super(nbt);
    }

    @Override
    public boolean revalidate(MTEExtremeIndustrialGreenhouse greenhouse) {
        return this.isValid();
    }

    @Override
    protected String getNBTIdentifier() {
        return NBT_IDENTIFIER;
    }

    @Override
    public void addProgress(double multiplier, EIGDropTable tracker) {
        if (!this.isValid()) {
            return;
        }
        ArrayList drops = new ArrayList();
        ((BlockRainbowCactus)TBBlocks.rainbowCactus).addDyeDropsToOutput(this.random, drops);
        for (ItemStack drop : drops) {
            tracker.addDrop(drop, (double)drop.field_77994_a * multiplier * (double)this.seedCount);
        }
    }

    public static class Factory
    implements IEIGBucketFactory {
        @Override
        public String getNBTIdentifier() {
            return EIGRainbowCactusBucket.NBT_IDENTIFIER;
        }

        @Override
        public EIGBucket tryCreateBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input) {
            if (!(Block.func_149634_a((Item)input.func_77973_b()) instanceof BlockRainbowCactus)) {
                return null;
            }
            return new EIGRainbowCactusBucket(input, 1);
        }

        @Override
        public EIGBucket restore(NBTTagCompound nbt) {
            return new EIGRainbowCactusBucket(nbt);
        }
    }
}

