/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.INEIPreviewModifier;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.RenderOverlay;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTUtilityClient;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.items.MetaGeneratedTool01;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTELargeTurbine
extends MTEEnhancedMultiBlockBase<MTELargeTurbine>
implements ISurvivalConstructable,
INEIPreviewModifier {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<MTELargeTurbine>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTELargeTurbine>>(){

        @Override
        protected IStructureDefinition<MTELargeTurbine> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTELargeTurbine.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"     ", "     ", "     ", "     ", "     "}, {" --- ", " ccc ", " hhh ", " hhh ", " hhh "}, {" --- ", " c~c ", " h-h ", " h-h ", " hdh "}, {" --- ", " ccc ", " hhh ", " hhh ", " hhh "}, {"     ", "     ", "     ", "     ", "     "}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).addElement('d', (IStructureElement)StructureUtility.lazy(t -> HatchElement.Dynamo.newAny(t.getCasingTextureIndex(), 1))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTELargeTurbine.class).atLeast(t.getHatchElements()).casingIndex(t.getCasingTextureIndex()).dot(2).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).build();
        }
    };
    protected int baseEff = 0;
    protected int optFlow = 0;
    protected double realOptFlow = 0.0;
    protected int storedFluid = 0;
    protected int counter = 0;
    protected boolean looseFit = false;
    protected int overflowMultiplier = 0;
    protected final float[] flowMultipliers = new float[]{1.0f, 1.0f, 1.0f};
    protected final List<RenderOverlay.OverlayTicket> overlayTickets = new ArrayList<RenderOverlay.OverlayTicket>();
    protected boolean mHasTurbine;
    protected boolean mFormed;

    public MTELargeTurbine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbine(String aName) {
        super(aName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    public IStructureDefinition<MTELargeTurbine> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> r.isNotRotated() && f.isNotFlipped();
    }

    @Override
    protected ExtendedFacing getCorrectedAlignment(ExtendedFacing aOldFacing) {
        return aOldFacing.with(Flip.NONE).with(Rotation.NORMAL);
    }

    public boolean isFlipChangeAllowed() {
        return false;
    }

    public boolean isRotationChangeAllowed() {
        return false;
    }

    protected IHatchElement<? super MTELargeTurbine>[] getHatchElements() {
        if (this.getPollutionPerTick(null) == 0) {
            return new IHatchElement[]{HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.InputBus};
        }
        return new IHatchElement[]{HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.InputBus, HatchElement.Muffler};
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 2, 1) && this.mMaintenanceHatches.size() == 1 && this.mMufflerHatches.isEmpty() == (this.getPollutionPerTick(null) == 0);
    }

    public abstract Block getCasingBlock();

    public abstract byte getCasingMeta();

    public abstract int getCasingTextureIndex();

    @Deprecated
    public boolean isNewStyleRendering() {
        return false;
    }

    public IIconContainer[] getTurbineTextureActive() {
        return Textures.BlockIcons.TURBINE_NEW_ACTIVE;
    }

    public IIconContainer[] getTurbineTextureFull() {
        return Textures.BlockIcons.TURBINE_NEW;
    }

    public IIconContainer[] getTurbineTextureEmpty() {
        return Textures.BlockIcons.TURBINE_NEW_EMPTY;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.setTurbineOverlay();
    }

    protected void setTurbineOverlay() {
        IGregTechTileEntity tile = this.getBaseMetaTileEntity();
        if (tile.isServerSide()) {
            return;
        }
        IIconContainer[] tTextures = tile.isActive() ? this.getTurbineTextureActive() : (this.hasTurbine() ? this.getTurbineTextureFull() : this.getTurbineTextureEmpty());
        GTUtilityClient.setTurbineOverlay(tile.getWorld(), tile.getXCoord(), tile.getYCoord(), tile.getZCoord(), this.getExtendedFacing(), tTextures, this.overlayTickets);
    }

    @Override
    public void onTextureUpdate() {
        this.setTurbineOverlay();
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mHasTurbine = (aValue & 1) != 0;
        this.mFormed = (aValue & 2) != 0;
        super.onValueUpdate(aValue);
        this.setTurbineOverlay();
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getBaseMetaTileEntity().isClientSide()) {
            GTUtilityClient.clearTurbineOverlay(this.overlayTickets);
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)((this.hasTurbine() ? 1 : 0) | (this.mMachine ? 2 : 0));
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity tTileEntity, int aBaseCasingIndex) {
        return this.addMaintenanceToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addOutputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getCasingTextureIndex());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack controllerSlot = this.getControllerSlot();
        if (!((this.counter & 7) != 0 || controllerSlot != null && controllerSlot.func_77973_b() instanceof MetaGeneratedTool && controllerSlot.func_77960_j() >= 170 && controllerSlot.func_77960_j() <= 179)) {
            this.stopMachine(ShutDownReasonRegistry.NO_TURBINE);
            return CheckRecipeResultRegistry.NO_TURBINE_FOUND;
        }
        TurbineStatCalculator turbine = new TurbineStatCalculator((MetaGeneratedTool)controllerSlot.func_77973_b(), controllerSlot);
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        if (!tFluids.isEmpty()) {
            if (this.baseEff == 0 || this.optFlow == 0 || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                this.counter = 0;
                this.baseEff = (int)(100.0f * turbine.getBaseEfficiency());
                this.optFlow = (int)turbine.getOptimalFlow();
                this.overflowMultiplier = turbine.getOverflowEfficiency();
                if (this.optFlow <= 0 || this.baseEff <= 0) {
                    this.stopMachine(ShutDownReasonRegistry.NONE);
                    return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                }
            } else {
                ++this.counter;
            }
        }
        int newPower = this.fluidIntoPower(tFluids, turbine);
        int difference = newPower - this.mEUt;
        int maxChangeAllowed = Math.max(10, GTUtility.safeInt((long)Math.abs(difference) / 100L));
        if (Math.abs(difference) > maxChangeAllowed) {
            int change = maxChangeAllowed * (difference > 0 ? 1 : -1);
            this.mEUt += change;
        } else {
            this.mEUt = newPower;
        }
        if (this.mEUt <= 0) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
        this.mMaxProgresstime = 1;
        this.mEfficiencyIncrease = 10;
        return CheckRecipeResultRegistry.GENERATING;
    }

    abstract int fluidIntoPower(ArrayList<FluidStack> var1, TurbineStatCalculator var2);

    abstract float getOverflowEfficiency(int var1, int var2, int var3);

    public long getMaximumOutput() {
        long aTotal = 0L;
        for (MTEHatchDynamo aDynamo : GTUtility.validMTEList(this.mDynamoHatches)) {
            long aVoltage = aDynamo.maxEUOutput();
            aTotal = aDynamo.maxAmperesOut() * aVoltage;
        }
        return aTotal;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return 0;
        }
        if (aStack.func_77973_b() instanceof MetaGeneratedTool01) {
            return 10000;
        }
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        int tDura = 0;
        if (this.mInventory[1] != null && this.mInventory[1].func_77973_b() instanceof MetaGeneratedTool01) {
            tDura = GTUtility.safeInt((long)(100.0f / (float)MetaGeneratedTool.getToolMaxDamage(this.mInventory[1]) * (float)MetaGeneratedTool.getToolDamage(this.mInventory[1]) + 1.0f));
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchDynamo tHatch : GTUtility.validMTEList(this.mDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{tRunning + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers((long)this.mEUt * (long)this.mEfficiency / 10000L) + EnumChatFormatting.RESET + " EU/t", tMaintainance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(GTUtility.safeInt((long)this.realOptFlow)) + EnumChatFormatting.RESET + " L/" + (this.mMaxProgresstime == 1 ? (char)'t' : 's') + EnumChatFormatting.YELLOW + " (" + (this.looseFit ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GTUtility.formatNumbers(this.storedFluid) + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + EnumChatFormatting.RED + tDura + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
    }

    public boolean hasTurbine() {
        return this.getBaseMetaTileEntity() != null && this.getBaseMetaTileEntity().isClientSide() ? this.mHasTurbine : this.getMaxEfficiency(this.mInventory[1]) > 0;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GTUtility.sendChatToPlayer(aPlayer, this.looseFit ? GTUtility.trans("500", "Fitting: Loose - More Flow") : GTUtility.trans("501", "Fitting: Tight - More Efficiency"));
        }
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 2, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 2, 1, elementBudget, env, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_LARGE_TURBINES_LOOP;
    }

    @Override
    public void onPreviewStructureComplete(@NotNull ItemStack trigger) {
        this.mFormed = true;
    }
}

