/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis.mega;

import bartworks.common.configs.Configuration;
import bartworks.common.tileentities.multis.mega.MegaMultiBlockBase;
import bartworks.util.BWUtil;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.pollution.PollutionConfig;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEMegaBlastFurnace
extends MegaMultiBlockBase<MTEMegaBlastFurnace>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 11;
    private static final IStructureDefinition<MTEMegaBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", MTEMegaBlastFurnace.createShape()).addElement('=', MegaMultiBlockBase.StructureElementAirNoHint.getInstance()).addElement('t', GTStructureUtility.buildHatchAdder(MTEMegaBlastFurnace.class).atLeast(HatchElement.OutputHatch).casingIndex(11).dot(1).buildAndChain(GregTechAPI.sBlockCasings1, 11)).addElement('m', HatchElement.Muffler.newAny(11, 2)).addElement('C', GTStructureChannels.HEATING_COIL.use(GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEMegaBlastFurnace::setCoilLevel, MTEMegaBlastFurnace::getCoilLevel)))).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('b', GTStructureUtility.buildHatchAdder(MTEMegaBlastFurnace.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy.or(HatchElement.ExoticEnergy)).casingIndex(11).dot(1).buildAndChain(GregTechAPI.sBlockCasings1, 11)).build();
    private HeatingCoilLevel mCoilLevel;
    private int mHeatingCapacity;
    private int glassTier = -1;
    private static final int polPtick = PollutionConfig.basePollutionMBFSecond / 20 * Configuration.Multiblocks.megaMachinesMax;

    private static String[][] createShape() {
        int i;
        String[][] raw = new String[20][];
        raw[0] = new String[15];
        String topCasing = "ttttttttttttttt";
        String middleTopCasing = "tttttttmttttttt";
        raw[0][0] = topCasing;
        for (int i2 = 1; i2 < 15; ++i2) {
            raw[0][i2] = topCasing;
        }
        raw[0][7] = middleTopCasing;
        raw[1] = new String[15];
        String allGlass = "ggggggggggggggg";
        String allCoil = "gCCCCCCCCCCCCCg";
        String middleLine = "gC===========Cg";
        raw[1][0] = allGlass;
        raw[1][1] = allCoil;
        raw[1][13] = allCoil;
        raw[1][14] = allGlass;
        for (i = 2; i < 13; ++i) {
            raw[1][i] = middleLine;
        }
        for (i = 2; i < 19; ++i) {
            raw[i] = raw[1];
        }
        String bottomCasing = "bbbbbbbbbbbbbbb";
        raw[19] = new String[15];
        for (int i3 = 0; i3 < 15; ++i3) {
            raw[19][i3] = bottomCasing;
        }
        raw[17] = Arrays.copyOf(raw[17], raw[17].length);
        raw[17][0] = "ggggggg~ggggggg";
        return StructureUtility.transpose((String[][])raw);
    }

    public MTEMegaBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMegaBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEMegaBlastFurnace(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Blast Furnace, MEBF, MBF").addStaticParallelInfo(Configuration.Multiblocks.megaMachinesMax).addInfo("Increases Heat by " + EnumChatFormatting.RED + "100K" + EnumChatFormatting.GRAY + " for every " + TooltipHelper.tierText("Voltage") + " tier past " + EnumChatFormatting.AQUA + "MV").addInfo("Reduces " + TooltipHelper.effText("EU Usage") + " by " + EnumChatFormatting.WHITE + "5%" + EnumChatFormatting.GRAY + " every " + EnumChatFormatting.RED + "900K" + EnumChatFormatting.GRAY + " above the recipe requirement").addInfo("Every " + EnumChatFormatting.RED + "1800K" + EnumChatFormatting.GRAY + " over the recipe requirement grants 1 " + EnumChatFormatting.LIGHT_PURPLE + "Perfect Overclock").addTecTechHatchInfo().addGlassEnergyLimitInfo().addMinGlassForLaser(8).addUnlimitedTierSkips().addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(15, 20, 15, true).addController("3rd layer center").addCasingInfoRange("Heat Proof Machine Casing", 0, 447, false).addCasingInfoExactly("Heating Coils", 864, true).addCasingInfoExactly("Any Tiered Glass", 1007, true).addStructureInfo("The glass tier limits the Energy Input tier").addEnergyHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").addMufflerHatch("Top middle").addInputBus("Any bottom layer casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("Any Heat Proof Machine Casing").addStructureHint("This Mega Multiblock is too big to have its structure hologram displayed fully.").addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.HEATING_COIL).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.glassTier = aNBT.func_74762_e("glasTier");
        if (!aNBT.func_74764_b("inputSeparation")) {
            this.inputSeparation = aNBT.func_74767_n("isBussesSeparate");
        }
        if (!aNBT.func_74764_b("batchMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!aPlayer.func_70093_af()) {
            this.inputSeparation = !this.inputSeparation;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
            return true;
        }
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("glasTier", this.glassTier);
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return polPtick * 20;
    }

    @Override
    protected String[] getExtendedInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mHeatingCapacity) + EnumChatFormatting.RESET + " K"};
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setRecipeHeat(recipe.mSpecialValue).setMachineHeat(MTEMegaBlastFurnace.this.mHeatingCapacity).setHeatOC(true).setHeatDiscount(true);
            }

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                return recipe.mSpecialValue <= MTEMegaBlastFurnace.this.mHeatingCapacity ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat(recipe.mSpecialValue);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return Configuration.Multiblocks.megaMachinesMax;
    }

    @Override
    public IStructureDefinition<MTEMegaBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 7, 17, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        this.glassTier = -1;
        this.setCoilLevel(HeatingCoilLevel.None);
        return this.survivalBuildPiece("main", stackSize, 7, 17, 0, realBudget, env, false, true);
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.mCoilLevel = aCoilLevel;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.mCoilLevel;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mHeatingCapacity = 0;
        this.glassTier = -1;
        this.setCoilLevel(HeatingCoilLevel.None);
        if (!this.checkPiece("main", 7, 17, 0) || this.getCoilLevel() == HeatingCoilLevel.None || this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (this.glassTier < 8) {
            for (MTEHatch hatch : this.mExoticEnergyHatches) {
                if (hatch.getConnectionType() == MTEHatch.ConnectionType.LASER) {
                    return false;
                }
                if (this.glassTier >= hatch.mTier) continue;
                return false;
            }
            for (MTEHatchEnergy mEnergyHatch : this.mEnergyHatches) {
                if (this.glassTier >= mEnergyHatch.mTier) continue;
                return false;
            }
        }
        this.mHeatingCapacity = (int)this.getCoilLevel().getHeat() + 100 * (BWUtil.getTier(this.getMaxInputEu()) - 2);
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.blastFurnaceRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -2;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MEGA_BLAST_FURNACE_LOOP;
    }
}

