/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.component;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.AutoValue_DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class $AutoValue_DisplayComponent
extends DisplayComponent {
    private final Component component;
    private final Optional<Integer> stackSize;
    private final Optional<String> additionalInfo;
    private final Tooltip additionalTooltip;

    $AutoValue_DisplayComponent(Component component, Optional<Integer> stackSize, Optional<String> additionalInfo, Tooltip additionalTooltip) {
        if (component == null) {
            throw new NullPointerException("Null component");
        }
        this.component = component;
        if (stackSize == null) {
            throw new NullPointerException("Null stackSize");
        }
        this.stackSize = stackSize;
        if (additionalInfo == null) {
            throw new NullPointerException("Null additionalInfo");
        }
        this.additionalInfo = additionalInfo;
        if (additionalTooltip == null) {
            throw new NullPointerException("Null additionalTooltip");
        }
        this.additionalTooltip = additionalTooltip;
    }

    @Override
    public Component component() {
        return this.component;
    }

    @Override
    public Optional<Integer> stackSize() {
        return this.stackSize;
    }

    @Override
    public Optional<String> additionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public Tooltip additionalTooltip() {
        return this.additionalTooltip;
    }

    public String toString() {
        return "DisplayComponent{component=" + this.component + ", stackSize=" + this.stackSize + ", additionalInfo=" + this.additionalInfo + ", additionalTooltip=" + this.additionalTooltip + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayComponent) {
            DisplayComponent that = (DisplayComponent)o;
            return this.component.equals(that.component()) && this.stackSize.equals(that.stackSize()) && this.additionalInfo.equals(that.additionalInfo()) && this.additionalTooltip.equals(that.additionalTooltip());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.component.hashCode();
        h$ *= 1000003;
        h$ ^= this.stackSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.additionalInfo.hashCode();
        h$ *= 1000003;
        return h$ ^= this.additionalTooltip.hashCode();
    }

    @Override
    public DisplayComponent.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends DisplayComponent.Builder {
        private Component component;
        private Optional<Integer> stackSize = Optional.empty();
        private Optional<String> additionalInfo = Optional.empty();
        private Tooltip additionalTooltip;

        Builder() {
        }

        private Builder(DisplayComponent source) {
            this.component = source.component();
            this.stackSize = source.stackSize();
            this.additionalInfo = source.additionalInfo();
            this.additionalTooltip = source.additionalTooltip();
        }

        @Override
        public DisplayComponent.Builder setComponent(Component component) {
            if (component == null) {
                throw new NullPointerException("Null component");
            }
            this.component = component;
            return this;
        }

        @Override
        public DisplayComponent.Builder setStackSize(Optional<Integer> stackSize) {
            if (stackSize == null) {
                throw new NullPointerException("Null stackSize");
            }
            this.stackSize = stackSize;
            return this;
        }

        @Override
        public DisplayComponent.Builder setStackSize(int stackSize) {
            this.stackSize = Optional.of(stackSize);
            return this;
        }

        @Override
        public DisplayComponent.Builder setAdditionalInfo(Optional<String> additionalInfo) {
            if (additionalInfo == null) {
                throw new NullPointerException("Null additionalInfo");
            }
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Override
        public DisplayComponent.Builder setAdditionalInfo(@Nullable String additionalInfo) {
            this.additionalInfo = Optional.ofNullable(additionalInfo);
            return this;
        }

        @Override
        public DisplayComponent.Builder setAdditionalTooltip(Tooltip additionalTooltip) {
            if (additionalTooltip == null) {
                throw new NullPointerException("Null additionalTooltip");
            }
            this.additionalTooltip = additionalTooltip;
            return this;
        }

        @Override
        public DisplayComponent build() {
            if (this.component == null || this.additionalTooltip == null) {
                StringBuilder missing = new StringBuilder();
                if (this.component == null) {
                    missing.append(" component");
                }
                if (this.additionalTooltip == null) {
                    missing.append(" additionalTooltip");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DisplayComponent(this.component, this.stackSize, this.additionalInfo, this.additionalTooltip);
        }
    }
}

