/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag.registry;

import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.TagFormatting;
import com.github.lunatrius.ingameinfo.tag.TagMisc;
import com.github.lunatrius.ingameinfo.tag.TagMouseOver;
import com.github.lunatrius.ingameinfo.tag.TagNearbyPlayer;
import com.github.lunatrius.ingameinfo.tag.TagPlayerEquipment;
import com.github.lunatrius.ingameinfo.tag.TagPlayerGeneral;
import com.github.lunatrius.ingameinfo.tag.TagPlayerPosition;
import com.github.lunatrius.ingameinfo.tag.TagPlayerPotion;
import com.github.lunatrius.ingameinfo.tag.TagRiding;
import com.github.lunatrius.ingameinfo.tag.TagTime;
import com.github.lunatrius.ingameinfo.tag.TagWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagRegistry {
    public static final TagRegistry INSTANCE = new TagRegistry();
    private final Map<String, Tag> stringTagMap = new HashMap<String, Tag>();

    private void register(String name, Tag tag) {
        if (this.stringTagMap.containsKey(name)) {
            Reference.logger.error("Duplicate tag key '{}'!", new Object[]{name});
            return;
        }
        if (name == null) {
            Reference.logger.error("Tag name cannot be null!");
            return;
        }
        this.stringTagMap.put(name.toLowerCase(), tag);
    }

    public void register(Tag tag) {
        this.register(tag.getName(), tag);
        for (String name : tag.getAliases()) {
            this.register(name, tag);
        }
    }

    public String getValue(String name) {
        Tag tag = this.stringTagMap.get(name.toLowerCase());
        return tag != null ? tag.getValue() : null;
    }

    public Tag getTag(String name) {
        return this.stringTagMap.get(name.toLowerCase());
    }

    public List<Tag> getRegisteredTags() {
        return new ArrayList<Tag>(this.stringTagMap.values());
    }

    public void init() {
        TagFormatting.register();
        TagMisc.register();
        TagMouseOver.register();
        TagNearbyPlayer.register();
        TagPlayerEquipment.register();
        TagPlayerGeneral.register();
        TagPlayerPosition.register();
        TagPlayerPotion.register();
        TagRiding.register();
        TagTime.register();
        TagWorld.register();
        Reference.logger.info("Registered {} tags.", new Object[]{this.stringTagMap.size()});
    }
}

