/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    private static final Map<String, Class<?>> mCachedClasses = new HashMap();
    private static final Map<String, Field> mCachedFields = new HashMap<String, Field>();

    public static Class<?> getClass(String aClassCanonicalName) {
        if (aClassCanonicalName == null || aClassCanonicalName.isEmpty()) {
            return null;
        }
        Class<?> clazz = mCachedClasses.get(aClassCanonicalName);
        if (clazz == null) {
            try {
                clazz = Class.forName(aClassCanonicalName);
                mCachedClasses.put(clazz.getCanonicalName(), clazz);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return clazz;
    }

    public static Field getField(Class<?> aClass, String aFieldName) {
        if (aClass == null || aFieldName == null || aFieldName.isEmpty()) {
            return null;
        }
        Field field = mCachedFields.get(aClass.getName() + "." + aFieldName);
        if (field == null) {
            try {
                field = aClass.getDeclaredField(aFieldName);
                field.setAccessible(true);
                mCachedFields.put(aClass.getName() + "." + aFieldName, field);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        return field;
    }

    public static Object getField(Object aInstance, String aFieldName) {
        try {
            return ReflectionUtils.getField(aInstance.getClass(), aFieldName).get(aInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }
}

