/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.packet.PacketCustom;
import codechicken.wirelessredstone.addons.ClientMapInfo;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.GuiWirelessSniffer;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.core.FreqCoord;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.World;

public class WRAddonCPH
implements PacketCustom.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient handler) {
        this.handlePacket(mc.field_71441_e, (EntityPlayer)mc.field_71439_g, packet);
    }

    private void handlePacket(WorldClient world, EntityPlayer player, PacketCustom packet) {
        switch (packet.getType()) {
            case 53: {
                WRAddonCPH.processSnifferFreqUpdate(packet);
                break;
            }
            case 54: {
                WRAddonCPH.processSnifferEtherCopy(packet);
                break;
            }
            case 55: {
                RedstoneEtherAddons.client().setTriangAngle(packet.readUShort(), packet.readFloat());
                break;
            }
            case 56: {
                WRAddonCPH.processMapInfo((World)world, player, packet);
                break;
            }
            case 57: {
                WRAddonCPH.processMapUpdate((World)world, player, packet);
                break;
            }
            case 59: {
                if (packet.readBoolean()) {
                    this.throwREP(packet.readInt(), packet.readInt(), world, player);
                    break;
                }
                world.func_73028_b(packet.readInt());
                break;
            }
            case 60: {
                this.processTrackerUpdate(packet, world, player);
                break;
            }
            case 61: {
                if (packet.readBoolean()) {
                    this.throwTracker(world, player, packet.readInt(), packet.readInt(), packet.readUShort());
                    break;
                }
                world.func_73028_b(packet.readInt());
            }
        }
    }

    private void throwTracker(WorldClient world, EntityPlayer player, int entityID, int throwerID, int freq) {
        Entity thrower = world.func_73045_a(throwerID);
        if (throwerID == player.func_145782_y()) {
            thrower = player;
        }
        if (thrower != null && thrower instanceof EntityLiving) {
            EntityWirelessTracker tracker = new EntityWirelessTracker((World)world, 0, (EntityLivingBase)((EntityLiving)thrower));
            tracker.func_145769_d(entityID);
            world.func_73027_a(entityID, (Entity)tracker);
            world.func_72956_a(thrower, "random.bow", 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    }

    private void processTrackerUpdate(PacketCustom packet, WorldClient world, EntityPlayer player) {
        int entityID = packet.readInt();
        int freq = packet.readUShort();
        boolean attached = packet.readBoolean();
        Entity e = world.func_73045_a(entityID);
        if (e != null && e.field_70128_L) {
            e = null;
        }
        if (!(e instanceof EntityWirelessTracker)) {
            if (e != null) {
                throw new IllegalStateException("EntityID mapped to non tracker");
            }
            e = new EntityWirelessTracker((World)world, freq);
            e.func_145769_d(entityID);
            world.func_73027_a(entityID, e);
        }
        EntityWirelessTracker tracker = (EntityWirelessTracker)e;
        if (attached) {
            int attachedEntityID = packet.readInt();
            Object attachedEntity = attachedEntityID == player.func_145782_y() ? player : world.func_73045_a(attachedEntityID);
            if (attachedEntity == null) {
                return;
            }
            tracker.attached = true;
            tracker.attachedEntity = attachedEntity;
            tracker.attachedX = packet.readFloat();
            tracker.attachedY = packet.readFloat();
            tracker.attachedZ = packet.readFloat();
            tracker.attachedYaw = packet.readFloat();
        } else {
            tracker.attachedEntity = null;
            tracker.attached = false;
            tracker.field_70165_t = packet.readFloat();
            tracker.field_70163_u = packet.readFloat();
            tracker.field_70161_v = packet.readFloat();
            tracker.field_70159_w = packet.readFloat();
            tracker.field_70181_x = packet.readFloat();
            tracker.field_70179_y = packet.readFloat();
            tracker.func_70107_b(tracker.field_70165_t, tracker.field_70163_u, tracker.field_70161_v);
            tracker.func_70016_h(tracker.field_70159_w, tracker.field_70181_x, tracker.field_70179_y);
            tracker.attachmentCounter = packet.readUShort();
            tracker.item = packet.readBoolean();
        }
    }

    private void throwREP(int entityID, int throwerID, WorldClient world, EntityPlayer player) {
        Entity thrower = world.func_73045_a(throwerID);
        if (throwerID == player.func_145782_y()) {
            thrower = player;
        }
        if (thrower != null && thrower instanceof EntityLivingBase) {
            EntityREP rep = new EntityREP((World)world, (EntityLivingBase)thrower);
            rep.func_145769_d(entityID);
            world.func_73027_a(entityID, (Entity)rep);
        }
    }

    private static void processSnifferFreqUpdate(PacketCustom packet) {
        GuiScreen currentscreen = Minecraft.func_71410_x().field_71462_r;
        if (currentscreen == null || !(currentscreen instanceof GuiWirelessSniffer)) {
            return;
        }
        GuiWirelessSniffer sniffergui = (GuiWirelessSniffer)currentscreen;
        sniffergui.setEtherFreq(packet.readUShort(), packet.readBoolean());
    }

    private static void processSnifferEtherCopy(PacketCustom packet) {
        GuiScreen currentscreen = Minecraft.func_71410_x().field_71462_r;
        if (currentscreen == null || !(currentscreen instanceof GuiWirelessSniffer)) {
            return;
        }
        GuiWirelessSniffer sniffergui = (GuiWirelessSniffer)currentscreen;
        sniffergui.setEtherCopy(packet.readByteArray(packet.readUShort()));
    }

    private static void processMapUpdate(World world, EntityPlayer player, PacketCustom packet) {
        WirelessMapNodeStorage mapstorage = RedstoneEtherAddons.client().getMapNodes();
        int numaddednodes = packet.readUShort();
        for (int i = 0; i < numaddednodes; ++i) {
            FreqCoord node = new FreqCoord(packet.readShort(), -1, packet.readShort(), packet.readUShort());
            mapstorage.nodes.add(node);
        }
        int numremovednodes = packet.readUShort();
        for (int i = 0; i < numremovednodes; ++i) {
            FreqCoord node = new FreqCoord(packet.readShort(), -1, packet.readShort(), packet.readUShort());
            mapstorage.nodes.remove(node);
        }
        int numremotes = packet.readUShort();
        mapstorage.devices.clear();
        for (int i = 0; i < numremotes; ++i) {
            mapstorage.devices.add(new FreqCoord(packet.readInt(), -1, packet.readInt(), packet.readUShort()));
        }
    }

    private static void processMapInfo(World world, EntityPlayer player, PacketCustom packet) {
        short mapno = packet.readShort();
        int xCenter = packet.readInt();
        int zCenter = packet.readInt();
        byte scale = packet.readByte();
        RedstoneEtherAddons.client().setMPMapInfo(mapno, new ClientMapInfo(xCenter, zCenter, scale));
    }

    public static void sendOpenSniffer() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 50);
        packet.writeBoolean(true);
        packet.sendToServer();
    }

    public static void sendCloseSniffer() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 50);
        packet.writeBoolean(false);
        packet.sendToServer();
    }

    public static void sendSetRemote(boolean active) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 51);
        packet.writeBoolean(active);
        packet.sendToServer();
    }

    public static void sendSyncTriang(int freq, boolean required) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 52);
        packet.writeShort(freq);
        packet.writeBoolean(required);
        packet.sendToServer();
    }

    public static void sendResetMap() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 58);
        packet.sendToServer();
    }
}

