/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import com.enderio.core.common.util.Util;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.crusher.CrusherMachineRecipe;
import crazypants.enderio.machine.crusher.GrindingBall;
import crazypants.enderio.machine.crusher.GrindingBallTagHandler;
import crazypants.enderio.machine.crusher.IGrindingMultiplier;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeConfig;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrusherRecipeManager {
    public static final int ORE_ENERGY_COST = 400;
    public static final int INGOT_ENERGY_COST = 240;
    private static final String CORE_FILE_NAME = "SAGMillRecipes_Core.xml";
    private static final String CUSTOM_FILE_NAME = "SAGMillRecipes_User.xml";
    static final CrusherRecipeManager instance = new CrusherRecipeManager();
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<RecipeInput> ballExcludes = new ArrayList<RecipeInput>();
    private final List<GrindingBall> balls = new ArrayList<GrindingBall>();
    private Set<ItemStack> excludedStacks = new HashSet<ItemStack>();

    public static CrusherRecipeManager getInstance() {
        return instance;
    }

    public boolean isValidSagBall(ItemStack stack) {
        return this.getGrindballFromStack(stack) != null;
    }

    public boolean isExcludedFromBallBonus(MachineRecipeInput[] inputs) {
        if (inputs == null || inputs.length < 1) {
            return true;
        }
        for (MachineRecipeInput input : inputs) {
            String name;
            if (input.item == null) continue;
            if (this.isExcludedStack(input.item)) {
                return true;
            }
            int id = OreDictionary.getOreID((ItemStack)input.item);
            if (id < 0 || !(name = OreDictionary.getOreName((int)id)).startsWith("ingot") && !name.startsWith("block") && !name.startsWith("nugget")) continue;
            this.addExcludedStack(input.item);
            return true;
        }
        for (RecipeInput input : this.ballExcludes) {
            if (input == null || !input.isInput(inputs[0].item)) continue;
            this.addExcludedStack(inputs[0].item);
            return true;
        }
        return false;
    }

    private void addExcludedStack(ItemStack item) {
        item = item.func_77946_l();
        item.field_77994_a = 1;
        this.excludedStacks.add(item);
    }

    private boolean isExcludedStack(ItemStack item) {
        item = item.func_77946_l();
        item.field_77994_a = 1;
        return this.excludedStacks.contains(item);
    }

    public IGrindingMultiplier getGrindballFromStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (GrindingBall ball : this.balls) {
            if (!ball.isInput(stack)) continue;
            return ball;
        }
        return null;
    }

    public boolean isValidInput(MachineRecipeInput input) {
        if (input.slotNumber == 1) {
            return this.isValidSagBall(input.item);
        }
        return this.getRecipeForInput(input.item) != null;
    }

    public void loadRecipesFromConfig() {
        GrindingBallTagHandler th = new GrindingBallTagHandler();
        RecipeConfig config = RecipeConfig.loadRecipeConfig(CORE_FILE_NAME, CUSTOM_FILE_NAME, th);
        this.balls.addAll(th.balls.values());
        this.ballExcludes.addAll(th.excludes);
        Log.info("Loaded " + this.balls.size() + " grinding balls from SAG Mill config.");
        Log.info("Excluding " + this.ballExcludes.size() + " recipes from grinding balls bonus.");
        if (config != null) {
            this.processConfig(config);
        } else {
            Log.error("Could not load recipes for SAG Mill.");
        }
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSagMill.unlocalisedName, new CrusherMachineRecipe());
    }

    public void addCustomRecipes(String xmlDef) {
        RecipeConfig config;
        GrindingBallTagHandler th = new GrindingBallTagHandler();
        try {
            config = RecipeConfigParser.parse(xmlDef, (CustomTagHandler)th);
        }
        catch (Exception e) {
            Log.error("Error parsing custom xml");
            return;
        }
        this.balls.addAll(th.balls.values());
        this.ballExcludes.addAll(th.excludes);
        if (config == null) {
            Log.error("Could not process custom XML");
            return;
        }
        this.processConfig(config);
    }

    public IRecipe getRecipeForInput(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (Recipe recipe : this.recipes) {
            if (!recipe.isInputForRecipe(new MachineRecipeInput(0, input))) continue;
            return recipe;
        }
        return null;
    }

    private void processConfig(RecipeConfig config) {
        if (config.isDumpItemRegistery()) {
            Util.dumpModObjects((File)new File(Config.configDirectory, "modObjectsRegistery.txt"));
        }
        if (config.isDumpOreDictionary()) {
            Util.dumpOreNames((File)new File(Config.configDirectory, "oreDictionaryRegistery.txt"));
        }
        List<Recipe> newRecipes = config.getRecipes(true);
        Log.info("Found " + newRecipes.size() + " valid SAG Mill recipes in config.");
        for (Recipe rec : newRecipes) {
            this.addRecipe(rec);
        }
        Log.info("Finished processing SAG Mill recipes. " + this.recipes.size() + " recipes avaliable.");
    }

    public void addRecipe(ItemStack input, int energyCost, ItemStack output) {
        this.addRecipe(input, energyCost, new RecipeOutput(output, 1.0f));
    }

    public void addRecipe(ItemStack input, int energyCost, RecipeOutput ... output) {
        if (input == null || output == null) {
            return;
        }
        this.addRecipe(new Recipe(new RecipeInput(input, false), energyCost, RecipeBonusType.MULTIPLY_OUTPUT, output));
    }

    public void addRecipe(Recipe recipe) {
        if (recipe == null || !recipe.isValid()) {
            Log.debug("Could not add invalid recipe: " + recipe);
            return;
        }
        IRecipe rec = this.getRecipeForInput(CrusherRecipeManager.getInput(recipe));
        if (rec != null) {
            Log.warn("Not adding supplied recipe as a recipe already exists for the input: " + CrusherRecipeManager.getInput(recipe));
            return;
        }
        this.recipes.add(recipe);
    }

    public List<Recipe> getRecipes() {
        return this.recipes;
    }

    public static ItemStack getInput(IRecipe recipe) {
        if (recipe == null || recipe.getInputs() == null || recipe.getInputs().length == 0) {
            return null;
        }
        return recipe.getInputs()[0].getInput();
    }

    public List<GrindingBall> getBalls() {
        return this.balls;
    }
}

