/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.ConnectionModeGeometry;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.liquid.AbstractEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class EnderLiquidConduitRenderer
extends DefaultConduitRenderer {
    public static final ThreadLocal<ConduitRenderer> instance = ThreadLocal.withInitial(EnderLiquidConduitRenderer::new);

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight, RenderBlocks rb) {
        super.renderEntity(conduitBundleRenderer, te, conduit, x, y, z, partialTick, worldLight, rb);
        AbstractEnderLiquidConduit pc = (AbstractEnderLiquidConduit)conduit;
        for (ForgeDirection dir : conduit.getExternalConnections()) {
            DyeColor inChannel = null;
            DyeColor outChannel = null;
            IIcon inTex = null;
            IIcon outTex = null;
            boolean render = true;
            if (conduit.getConnectionMode(dir) == ConnectionMode.INPUT) {
                inTex = pc.getTextureForInputMode();
                inChannel = pc.getInputColor(dir);
            } else if (conduit.getConnectionMode(dir) == ConnectionMode.OUTPUT) {
                outTex = pc.getTextureForOutputMode();
                outChannel = pc.getOutputColor(dir);
            } else if (conduit.getConnectionMode(dir) == ConnectionMode.IN_OUT) {
                inTex = pc.getTextureForInOutMode(true);
                outTex = pc.getTextureForInOutMode(false);
                inChannel = pc.getInputColor(dir);
                outChannel = pc.getOutputColor(dir);
            } else {
                render = false;
            }
            if (!render || rb.func_147744_b()) continue;
            Offset offset = te.getOffset(ILiquidConduit.class, dir);
            ConnectionModeGeometry.renderModeConnector(dir, offset, pc.getTextureForInOutBackground(), true);
            if (inChannel != null) {
                Tessellator.field_78398_a.func_78378_d(inChannel.getColor());
                ConnectionModeGeometry.renderModeConnector(dir, offset, inTex, false);
            }
            if (outChannel != null) {
                Tessellator.field_78398_a.func_78378_d(outChannel.getColor());
                ConnectionModeGeometry.renderModeConnector(dir, offset, outTex, false);
            }
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        }
    }
}

