/*
 * Decompiled with CFR 0.152.
 */
package tb.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tb.init.TBItems;

public class BlockBriar
extends BlockBush
implements IGrowable {
    private IIcon[] doublePlantBottomIcons;
    private IIcon[] doublePlantTopIcons;
    public int growthStages;
    public int growthDelay;

    public BlockBriar(int stages, int g) {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.growthStages = stages;
        this.growthDelay = g;
    }

    public int func_149645_b() {
        return 6;
    }

    public void func_149674_a(World w, int x, int y, int z, Random rnd) {
        super.func_149674_a(w, x, y, z, rnd);
        if (w.func_147439_a(x, y, z) == this) {
            int meta = w.func_72805_g(x, y, z);
            if (this.isTopBlock(meta)) {
                if (meta - 8 < this.growthStages - 1 && w.field_73012_v.nextInt(this.growthDelay) == 0) {
                    w.func_72921_c(x, y, z, meta + 1, 3);
                    w.func_72921_c(x, y - 1, z, meta - 7, 3);
                }
            } else if (meta < this.growthStages - 1 && w.field_73012_v.nextInt(this.growthDelay) == 0) {
                w.func_72921_c(x, y, z, meta + 1, 3);
                w.func_72921_c(x, y + 1, z, meta + 9, 3);
            }
        }
    }

    public boolean func_149727_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int aSide, float pX, float pY, float pZ) {
        int aMeta = aWorld.func_72805_g(aX, aY, aZ);
        boolean isTop = this.isTopBlock(aMeta);
        int lowerY = isTop ? aY - 1 : aY;
        int upperY = lowerY + 1;
        int lowerMeta = aWorld.func_72805_g(aX, lowerY, aZ);
        int upperMeta = aWorld.func_72805_g(aX, upperY, aZ);
        if (lowerMeta < this.growthStages - 1 || upperMeta < this.growthStages - 1 + 8) {
            return false;
        }
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)aPlayer);
        for (ItemStack drop : this.getDrops(aWorld, aX, lowerY, aZ, upperMeta, fortune)) {
            this.func_149642_a(aWorld, aX, lowerY, aZ, drop);
        }
        aWorld.func_72921_c(aX, lowerY, aZ, 0, 2);
        aWorld.func_72921_c(aX, upperY, aZ, 8, 2);
        return true;
    }

    public void func_149719_a(IBlockAccess w, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        return super.func_149742_c(w, x, y, z) && w.func_147437_c(x, y + 1, z);
    }

    protected void func_149855_e(World w, int x, int y, int z) {
        int meta = w.func_72805_g(x, y, z);
        if (this.isTopBlock(meta)) {
            if (w.func_147439_a(x, y - 1, z) != this) {
                w.func_147468_f(x, y, z);
                this.func_149697_b(w, x, y, z, meta, 0);
            }
        } else {
            if (w.func_147439_a(x, y + 1, z) != this) {
                this.func_149697_b(w, x, y, z, meta, 0);
                w.func_147468_f(x, y, z);
                return;
            }
            if (!this.func_149718_j(w, x, y, z)) {
                this.func_149697_b(w, x, y + 1, z, meta, 0);
                w.func_147468_f(x, y + 1, z);
                this.func_149697_b(w, x, y, z, meta, 0);
                w.func_147468_f(x, y, z);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.isTopBlock(metadata)) {
            ret.add(new ItemStack((Block)this, 1, 0));
            return ret;
        }
        if ((metadata -= 8) >= this.growthStages - 1) {
            ret.add(new ItemStack(TBItems.resource, 1 + world.field_73012_v.nextInt(4), 6));
            return ret;
        }
        return ret;
    }

    public boolean func_149718_j(World w, int x, int y, int z) {
        return !w.func_147437_c(x, y - 1, z) && (w.func_147439_a(x, y - 1, z).isReplaceableOreGen(w, x, y - 1, z, (Block)Blocks.field_150349_c) || w.func_147439_a(x, y - 1, z).isReplaceableOreGen(w, x, y, z, Blocks.field_150346_d) || w.func_147439_a(x, y - 1, z).canSustainPlant((IBlockAccess)w, x, y - 1, z, ForgeDirection.UP, (IPlantable)this));
    }

    public boolean isTopBlock(int meta) {
        return meta > 7;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        w.func_147465_d(x, y + 1, z, (Block)this, 8, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.doublePlantBottomIcons = new IIcon[this.growthStages];
        this.doublePlantTopIcons = new IIcon[this.growthStages];
        for (int i = 0; i < this.growthStages; ++i) {
            this.doublePlantBottomIcons[i] = reg.func_94245_a(this.field_149768_d + "stage_" + i + "_bot");
            this.doublePlantTopIcons[i] = reg.func_94245_a(this.field_149768_d + "stage_" + i + "_top");
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.isTopBlock(meta) ? this.doublePlantTopIcons[meta - 8] : this.doublePlantBottomIcons[meta];
    }

    public boolean func_149851_a(World w, int x, int y, int z, boolean remote) {
        return w.func_72805_g(x, y, z) % 8 < this.growthStages - 1;
    }

    public boolean func_149852_a(World w, Random r, int x, int y, int z) {
        return w.func_72957_l(x, y + 1, z) >= 9;
    }

    public void func_149853_b(World w, Random r, int x, int y, int z) {
        if (w.func_147439_a(x, y, z) == this) {
            int meta = w.func_72805_g(x, y, z);
            if (this.isTopBlock(meta)) {
                if (meta - 8 < this.growthStages - 1 && w.field_73012_v.nextInt(this.growthDelay) == 0) {
                    w.func_72921_c(x, y, z, meta + 1, 3);
                    w.func_72921_c(x, y - 1, z, meta - 7, 3);
                }
            } else if (meta < this.growthStages - 1 && w.field_73012_v.nextInt(this.growthDelay) == 0) {
                w.func_72921_c(x, y, z, meta + 1, 3);
                w.func_72921_c(x, y + 1, z, meta + 9, 3);
            }
        }
    }
}

