/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tick;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import de.katzenpapst.amunra.helper.ShuttleTeleportHelper;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import de.katzenpapst.amunra.mothership.MothershipWorldData;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.world.ShuttleDockHandler;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class TickHandlerServer {
    public static MothershipWorldData mothershipData;
    public static ShuttleDockHandler dockData;

    public static void restart() {
        mothershipData = null;
        dockData = null;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            WorldServer world;
            if (dockData == null) {
                world = server.func_71218_a(0);
                dockData = (ShuttleDockHandler)world.field_72988_C.func_75742_a(ShuttleDockHandler.class, "ShuttleDock");
                if (dockData == null) {
                    dockData = new ShuttleDockHandler("ShuttleDock");
                    world.field_72988_C.func_75745_a("ShuttleDock", (WorldSavedData)dockData);
                }
            }
            if (mothershipData == null) {
                world = server.func_71218_a(0);
                mothershipData = (MothershipWorldData)world.field_72988_C.func_75742_a(MothershipWorldData.class, "ARMothershipData");
                if (mothershipData == null) {
                    mothershipData = new MothershipWorldData("ARMothershipData");
                    world.field_72988_C.func_75745_a("ARMothershipData", (WorldSavedData)mothershipData);
                }
            } else {
                mothershipData.tickAllMotherships();
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            WorldServer world = (WorldServer)event.world;
            if (world.field_73011_w instanceof MothershipWorldProvider) {
                Object[] entityList;
                for (Object o : entityList = world.field_72996_f.toArray()) {
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    if (!(e.field_70170_p.field_73011_w instanceof MothershipWorldProvider)) continue;
                    if (e.field_70163_u < 0.0) {
                        CelestialBody parent = ((MothershipWorldProvider)e.field_70170_p.field_73011_w).getParent();
                        if (parent == null) {
                            if (e instanceof EntityLivingBase) {
                                ((EntityLivingBase)e).func_70097_a(DamageSourceAR.dsFallOffShip, 9001.0f);
                                continue;
                            }
                            e.field_70170_p.func_72900_e(e);
                            continue;
                        }
                        if (!parent.getReachable() || parent.getTierRequirement() > AmunRa.config.mothershipMaxTier) {
                            if (e instanceof EntityLivingBase) {
                                ((EntityLivingBase)e).func_70097_a(DamageSourceAR.getDSCrashIntoPlanet(parent), 9001.0f);
                                continue;
                            }
                            e.field_70170_p.func_72900_e(e);
                            continue;
                        }
                        if (e instanceof EntityPlayerMP && e.field_70154_o instanceof EntityShuttle) {
                            this.sendPlayerInShuttleToPlanet((EntityPlayerMP)e, (EntityShuttle)e.field_70154_o, (World)world, parent.getDimensionID());
                            continue;
                        }
                        if (e instanceof EntityShuttle && e.field_70153_n instanceof EntityPlayerMP) {
                            this.sendPlayerInShuttleToPlanet((EntityPlayerMP)e.field_70153_n, (EntityShuttle)e, (World)world, parent.getDimensionID());
                            continue;
                        }
                        WorldUtil.transferEntityToDimension((Entity)e, (int)parent.getDimensionID(), (WorldServer)world, (boolean)false, null);
                        continue;
                    }
                    if (!(e instanceof EntityAutoRocket)) continue;
                    EntityAutoRocket rocket = (EntityAutoRocket)e;
                    MothershipWorldProvider msProvider = (MothershipWorldProvider)e.field_70170_p.field_73011_w;
                    if (!msProvider.isInTransit()) continue;
                    if (rocket.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
                        rocket.cancelLaunch();
                        continue;
                    }
                    if (rocket.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) continue;
                    if (rocket instanceof EntityShuttle) {
                        ((EntityShuttle)rocket).setLanding();
                        continue;
                    }
                    rocket.dropShipAsItem();
                    rocket.func_70106_y();
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        WorldProvider provider = event.player.func_130014_f_().field_73011_w;
        if (provider instanceof MothershipWorldProvider) {
            ((MothershipWorldProvider)provider).sendPacketsToClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = server.func_71218_a(event.toDim);
        if (world.field_73011_w instanceof MothershipWorldProvider) {
            ((MothershipWorldProvider)world.field_73011_w).sendPacketsToClient((EntityPlayerMP)event.player);
        }
    }

    protected void sendPlayerInShuttleToPlanet(EntityPlayerMP player, EntityShuttle shuttle, World world, int dimensionID) {
        if (world.field_72995_K) {
            return;
        }
        shuttle.field_70153_n = null;
        player.field_70154_o = null;
        shuttle.setGCPlayerStats(player);
        shuttle.func_70106_y();
        ShuttleTeleportHelper.transferEntityToDimension((Entity)player, dimensionID, (WorldServer)world);
    }
}

