/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixins.late.gregtech;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.basic.MTEAdvSeismicProspector;
import ic2.core.Ic2Items;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MTEAdvSeismicProspector.class}, remap=false)
public abstract class GT_MetaTileEntity_AdvSeismicProspectorMixin
extends MTEBasicMachine {
    @Shadow(remap=false)
    boolean ready = false;
    @Shadow(remap=false)
    int radius;

    public GT_MetaTileEntity_AdvSeismicProspectorMixin() {
        super(0, "", "", 0, 0, "", 0, 0, new ITexture[0]);
    }

    @Overwrite(remap=false)
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack aStack = aPlayer.func_71045_bC();
            if (!this.ready && (GTUtility.consumeItems((EntityPlayer)aPlayer, (ItemStack)aStack, (Item)Item.func_150898_a((Block)Blocks.field_150335_W), (int)16) || GTUtility.consumeItems((EntityPlayer)aPlayer, (ItemStack)aStack, (Item)Ic2Items.industrialTnt.func_77973_b(), (int)8) || GTUtility.consumeItems((EntityPlayer)aPlayer, (ItemStack)aStack, (Materials)Materials.Glyceryl, (int)4) || GTUtility.consumeItems((EntityPlayer)aPlayer, (ItemStack)aStack, (Item)ItemList.Block_Powderbarrel.getItem(), (int)2))) {
                this.ready = true;
                this.mMaxProgresstime = aPlayer.field_71075_bZ.field_75098_d ? 20 : 800;
            } else if (this.ready && this.mMaxProgresstime == 0 && aStack != null && aStack.field_77994_a == 1 && aStack.func_77973_b() == ItemList.Tool_DataStick.getItem()) {
                this.ready = false;
                NBTTagCompound compound = GTUtility.ItemNBT.getNBT((ItemStack)aStack);
                compound.func_74778_a("title", "Raw Prospection Data");
                compound.func_74757_a("is_visualprospecting_data", true);
                compound.func_74774_a("prospection_tier", this.mTier);
                compound.func_74768_a("prospection_dimension_id", this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
                compound.func_74768_a("prospection_block_x", this.getBaseMetaTileEntity().getXCoord());
                compound.func_74768_a("prospection_block_y", (int)this.getBaseMetaTileEntity().getYCoord());
                compound.func_74768_a("prospection_block_z", this.getBaseMetaTileEntity().getZCoord());
                compound.func_74768_a("prospection_ore_radius", this.radius);
                List<UndergroundFluidPosition> undergroundFluidPositions = ServerCache.instance.prospectUndergroundFluidBlockRadius(aPlayer.field_70170_p, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord(), 128);
                compound.func_74768_a("prospection_num_fluids", undergroundFluidPositions.size());
                CharSequence[] fluidStrings = new String[9];
                int minUndergroundFluidX = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(this.getBaseMetaTileEntity().getXCoord() - 128));
                int minUndergroundFluidZ = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(this.getBaseMetaTileEntity().getZCoord() - 128));
                for (UndergroundFluidPosition undergroundFluidPosition : undergroundFluidPositions) {
                    int offsetUndergroundFluidX = Utils.mapToCornerUndergroundFluidChunkCoord(undergroundFluidPosition.chunkX) - minUndergroundFluidX >> 3;
                    int offsetUndergroundFluidZ = Utils.mapToCornerUndergroundFluidChunkCoord(undergroundFluidPosition.chunkZ) - minUndergroundFluidZ >> 3;
                    int undergroundFluidBookId = offsetUndergroundFluidX + offsetUndergroundFluidZ * 3;
                    fluidStrings[undergroundFluidBookId] = undergroundFluidBookId + ": " + undergroundFluidPosition.getMinProduction() + "-" + undergroundFluidPosition.getMaxProduction() + " " + undergroundFluidPosition.fluid.getLocalizedName();
                }
                compound.func_74778_a("prospection_fluids", String.join((CharSequence)"|", fluidStrings));
                GTUtility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)compound);
            }
        }
        return true;
    }
}

