/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.witchery;

import com.dreammaster.witchery.WitcheryPlugin;
import com.emoniph.witchery.brewing.AltarPower;
import com.emoniph.witchery.brewing.BrewItemKey;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.brewing.action.BrewAction;
import com.emoniph.witchery.brewing.action.BrewActionRitualRecipe;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WitcheryBrewRegistryAccessor {
    static final Logger log;
    static final Method methodRegister;
    static final Field fieldRecipes;
    static final Hashtable<BrewItemKey, BrewAction> ingredient;

    WitcheryBrewRegistryAccessor() {
    }

    private static Hashtable<BrewItemKey, BrewAction> getIngredient(Field field) throws IllegalAccessException {
        return (Hashtable)field.get(WitcheryBrewRegistry.INSTANCE);
    }

    static void registerBrewAction(BrewAction action) {
        if (methodRegister != null) {
            try {
                methodRegister.invoke((Object)WitcheryBrewRegistry.INSTANCE, action);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Error registering brew action", (Throwable)e);
            }
        }
    }

    static void modifyBrewRecipe(BrewActionRitualRecipe ritualRecipe, BrewActionRitualRecipe.Recipe[] recipes) {
        WitcheryBrewRegistryAccessor.removeAction(ritualRecipe);
        AltarPower power = new AltarPower(0);
        ritualRecipe.accumulatePower(power);
        WitcheryBrewRegistryAccessor.registerBrewAction((BrewAction)new BrewActionRitualRecipe(ritualRecipe.ITEM_KEY, power, recipes));
    }

    static void removeAction(BrewActionRitualRecipe action) {
        ingredient.remove(action.ITEM_KEY);
        WitcheryBrewRegistry.INSTANCE.getRecipes().remove(action);
    }

    static BrewActionRitualRecipe.Recipe[] getRecipes(BrewActionRitualRecipe ritualRecipe) {
        try {
            return (BrewActionRitualRecipe.Recipe[])fieldRecipes.get(ritualRecipe);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static boolean isCauldronRecipeMatch(BrewActionRitualRecipe.Recipe recipe, ItemStack lastItem, ItemStack[] items) {
        ItemStack[] ingredients = recipe.ingredients;
        int length = ingredients.length;
        if (length != items.length + 1) {
            return false;
        }
        boolean[] found = new boolean[length];
        for (ItemStack item : items) {
            int i;
            boolean foundThisRound = false;
            for (i = 0; i < length - 1; ++i) {
                if (found[i] || !item.func_77969_a(ingredients[i])) continue;
                found[i] = true;
                foundThisRound = true;
                break;
            }
            if (!foundThisRound && !found[i] && lastItem.func_77969_a(ingredients[i])) {
                found[i] = true;
                foundThisRound = true;
            }
            if (foundThisRound) continue;
            return false;
        }
        return true;
    }

    static {
        Field f2;
        Hashtable<BrewItemKey, BrewAction> ingredient1;
        Method tmp;
        log = LogManager.getLogger((String)"WitcheryCompat");
        try {
            ClassLoader classLoader = WitcheryPlugin.class.getClassLoader();
            Class<?> clazz = Class.forName("com.emoniph.witchery.brewing.WitcheryBrewRegistry", false, classLoader);
            tmp = clazz.getDeclaredMethod("register", BrewAction.class);
            tmp.setAccessible(true);
            Field field = clazz.getDeclaredField("ingredients");
            field.setAccessible(true);
            ingredient1 = WitcheryBrewRegistryAccessor.getIngredient(field);
            clazz = Class.forName("com.emoniph.witchery.brewing.action.BrewActionRitualRecipe", false, classLoader);
            f2 = clazz.getDeclaredField("recipes");
            f2.setAccessible(true);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            log.error("Cannot find Witchery brew registry stuff. Related functionality will have no effect!", (Throwable)e);
            tmp = null;
            ingredient1 = null;
            f2 = null;
        }
        ingredient = ingredient1;
        methodRegister = tmp;
        fieldRecipes = f2;
    }
}

