/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import pcl.openprinter.OpenPrinter;
import pcl.openprinter.tileentity.ShredderTE;

public class BlockShredder
extends BlockContainer {
    private Random random;
    @SideOnly(value=Side.CLIENT)
    public static IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon frontIcon;

    public BlockShredder() {
        super(Material.field_151573_f);
        this.func_149647_a(OpenPrinter.CreativeTab);
        this.func_149663_c("shredder");
        this.func_149711_c(0.5f);
        this.random = new Random();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        ShredderTE tileEntity = (ShredderTE)world.func_147438_o(x, y, z);
        this.dropContent(tileEntity, world, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void dropContent(IInventory chest, World world, int xCoord, int yCoord, int zCoord) {
        if (chest == null) {
            return;
        }
        for (int i1 = 0; i1 < chest.func_70302_i_(); ++i1) {
            ItemStack itemstack = chest.func_70301_a(i1);
            if (itemstack == null) continue;
            float offsetX = this.random.nextFloat() * 0.8f + 0.1f;
            float offsetY = this.random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int stackSize = this.random.nextInt(21) + 10;
                if (stackSize > itemstack.field_77994_a) {
                    stackSize = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= stackSize;
                EntityItem entityitem = new EntityItem(world, (double)((float)xCoord + offsetX), (double)((float)yCoord + offsetY), (double)((float)zCoord + offsetZ), new ItemStack(itemstack.func_77973_b(), stackSize, itemstack.func_77960_j()));
                float velocity = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * velocity;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * velocity + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * velocity;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public boolean func_149662_c() {
        return !OpenPrinter.render3D;
    }

    public boolean func_149686_d() {
        return !OpenPrinter.render3D;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float clickX, float clickY, float clickZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)OpenPrinter.instance, 2, world, x, y, z);
        return true;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        par1World.func_72921_c(par2, par3, par4, l + 1, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister registry) {
        registry.func_94245_a("openprinter:shredder");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        sideIcon = ir.func_94245_a("openprinter:block_side");
        frontIcon = ir.func_94245_a("openprinter:shredder_front");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        switch (i) {
            case 2: {
                if (j == 1) {
                    return frontIcon;
                }
                return sideIcon;
            }
            case 3: {
                if (j == 0) {
                    return frontIcon;
                }
                if (j == 3) {
                    return frontIcon;
                }
                return sideIcon;
            }
            case 4: {
                if (j == 4) {
                    return frontIcon;
                }
                return sideIcon;
            }
            case 5: {
                if (j == 2) {
                    return frontIcon;
                }
                return sideIcon;
            }
        }
        return sideIcon;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new ShredderTE();
    }
}

