/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.natura;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.crops.cpp.CactiCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import gregtech.api.enums.Mods;
import ic2.api.crops.ICropTile;
import mods.natura.common.NContent;
import net.minecraft.item.ItemStack;

public class SaguaroCrop
extends CactiCrop {
    @Override
    public int tier() {
        return 4;
    }

    @Override
    public String name() {
        return "Saguaro Cactus";
    }

    @Override
    public String[] attributes() {
        return new String[]{"Green", "Food", "Cactus"};
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        if (crop.getSize() >= this.maxSize() - 1) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= this.maxSize() - 1;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return ConfigValues.debug ? 1 : 225;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (Mods.Natura.isModLoaded()) {
            if (crop.getSize() == this.maxSize() - 1) {
                return new ItemStack(NContent.saguaro, 2, 0);
            }
            return new ItemStack(NContent.seedFood, 3, 0);
        }
        return new ItemStack(CppItems.BerryItems, 1, 4);
    }

    @Override
    public ItemStack getDisplayItem() {
        if (Mods.Natura.isModLoaded()) {
            return new ItemStack(NContent.seedFood, 3, 0);
        }
        return new ItemStack(CppItems.BerryItems, 1, 4);
    }
}

