/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.spider;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.spider.Entity_SpecialSpider;

public class EntityWitchSpider
extends Entity_SpecialSpider {
    private static final String TAG_DEFLECTED_PROJECTILE = "witchSpiderDeflected";
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "spider/witch.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "spider/witch_eyes.png")};

    public EntityWitchSpider(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        int id = Potion.field_76425_a.length;
        while (id-- > 0) {
            this.getSpecialData().immuneToPotions.add(id);
        }
        this.field_70728_aV += 2;
    }

    @Override
    public void onTypeAttack(Entity target) {
        if (target instanceof EntityLivingBase) {
            switch (target.field_70170_p.field_73013_u) {
                case PEACEFUL: {
                    return;
                }
                case EASY: {
                    int time = 15;
                    break;
                }
                case NORMAL: {
                    int time = 35;
                    break;
                }
                default: {
                    int time = 75;
                }
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, time *= 20, -3));
        }
    }

    protected void func_70600_l(int superRare) {
        Item drop = null;
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                drop = Items.field_151137_ax;
                break;
            }
            case 1: {
                drop = Items.field_151114_aO;
                break;
            }
            case 2: {
                drop = Items.field_151073_bk;
                break;
            }
            case 3: {
                drop = Items.field_151065_br;
                break;
            }
            case 4: {
                drop = Items.field_151064_bs;
            }
        }
        if (drop != null) {
            this.func_145779_a(drop, 1);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        Entity entity = damageSource.func_76364_f();
        if (damageSource.func_76352_a() && entity != null) {
            NBTTagCompound data = entity.getEntityData();
            if (data == null || data.func_74764_b(TAG_DEFLECTED_PROJECTILE) && data.func_74767_n(TAG_DEFLECTED_PROJECTILE)) {
                return super.func_70097_a(damageSource, damage);
            }
            Entity deflected = null;
            String entityName = EntityList.func_75621_b((Entity)entity);
            if (entityName != null) {
                deflected = EntityList.func_75620_a((String)entityName, (World)this.field_70170_p);
            }
            if (deflected != null) {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_70109_d(tag);
                deflected.func_70020_e(tag);
                NBTTagCompound deflectedData = deflected.getEntityData();
                if (deflectedData == null) {
                    return super.func_70097_a(damageSource, damage);
                }
                deflectedData.func_74757_a(TAG_DEFLECTED_PROJECTILE, true);
                if (entity instanceof EntityArrow) {
                    ((EntityArrow)deflected).field_70250_c = this;
                } else if (entity instanceof EntityFireball) {
                    ((EntityFireball)deflected).field_70235_a = this;
                    ((EntityFireball)deflected).field_70232_b *= -1.0;
                    ((EntityFireball)deflected).field_70233_c *= -1.0;
                    ((EntityFireball)deflected).field_70230_d *= -1.0;
                }
                deflected.func_70012_b(deflected.field_70165_t, deflected.field_70163_u, deflected.field_70161_v, -deflected.field_70177_z, -deflected.field_70125_A);
                deflected.field_70159_w *= -1.0;
                deflected.field_70181_x *= -1.0;
                deflected.field_70179_y *= -1.0;
                this.field_70170_p.func_72956_a((Entity)this, "random.orb", 0.3f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d(deflected);
                }
                entity.func_70106_y();
                return false;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }
}

