/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.utils.math;

public class FastMath {
    public static final double EPSILON_D = 2.220446049250313E-16;
    public static final float EPSILON_F = 1.1920929E-7f;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final double TWO_PI_D = Math.PI * 2;
    public static final double HALF_PI_D = 1.5707963267948966;
    public static final double QUARTER_PI_D = 0.7853981633974483;
    private static float[] a = new float[65536];

    public static float invSqrtF(float f) {
        float xHalf = 0.5f * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5f - xHalf * f * f;
        return f;
    }

    public static double invSqrtD(double d) {
        double xHalf = 0.5 * d;
        long i = Double.doubleToLongBits(d);
        i = 6910470738111508698L - (i >> 1);
        d = Double.longBitsToDouble(i);
        d *= 1.5 - xHalf * d * d;
        return d;
    }

    public static float tan(float f) {
        if (f == Float.NaN || f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
            return Float.NaN;
        }
        float cos = FastMath.cos(f);
        return cos == 0.0f ? Float.NaN : FastMath.sin(f) / cos;
    }

    public static float cot(float f) {
        if (f == Float.NaN || f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
            return Float.NaN;
        }
        float sin = FastMath.sin(f);
        return sin == 0.0f ? Float.NaN : FastMath.cos(f) / sin;
    }

    public static float asin(float fValue) {
        if (-1.0f >= fValue) {
            return -1.5707964f;
        }
        if (fValue < 1.0f) {
            return (float)Math.asin(fValue);
        }
        return 1.5707964f;
    }

    public static float acos(float fValue) {
        if (-1.0f >= fValue) {
            return (float)Math.PI;
        }
        if (fValue < 1.0f) {
            return (float)Math.acos(fValue);
        }
        return 0.0f;
    }

    public static float sin(float f) {
        return a[(int)(f * 10430.378f) & 0xFFFF];
    }

    public static float cos(float f) {
        return a[(int)(f * 10430.378f + 16384.0f) & 0xFFFF];
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            FastMath.a[i] = (float)Math.sin(Math.PI * 2 * (double)i / 65536.0);
        }
    }
}

