/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.electric;

import cpw.mods.fml.common.Optional;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumChatFormatting;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.api.energy.IEnergizedItem", modid="Mekanism"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2API")})
public interface ElectricItem
extends IItemElectric,
IEnergizedItem,
ISpecialElectricItem {
    public float getMaxTransfer();

    default public void addEnergyInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advanced) {
        float joules = this.getElectricityStored(itemStack);
        String color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? EnumChatFormatting.DARK_RED.toString() : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? EnumChatFormatting.DARK_GREEN.toString() : EnumChatFormatting.GOLD.toString());
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    default public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.getMaxTransfer()) {
            rejectedElectricity += energyToReceive - this.getMaxTransfer();
            energyToReceive = this.getMaxTransfer();
        }
        if (doRecharge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    default public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.getMaxTransfer());
        if (doDischarge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    default public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    default public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    default public float getTransfer(ItemStack itemStack) {
        return Math.min(this.getMaxTransfer(), this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    default public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    default public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    default public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    default public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    default public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxTransfer() * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    default public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    default public boolean canSend(ItemStack itemStack) {
        return true;
    }

    default public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    default public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    default public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    default public int getTier(ItemStack itemStack) {
        return 1;
    }

    default public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    default public double getTransferLimit(ItemStack itemStack) {
        return this.getMaxTransfer() * EnergyConfigHandler.TO_IC2_RATIO;
    }

    @Optional.Method(modid="IC2API")
    default public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2Compat.ITEM_MANAGER;
    }

    public static class IC2Compat {
        public static final IElectricItemManager ITEM_MANAGER = new ElectricItemManagerIC2_1710();
    }
}

