/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.core.block.machine.BlockMachine;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.tile.machine.TileEntitySolarWind;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSolarWindPanel
extends BlockMachine
implements IPartialSealableBlock {
    private final IIcon[] icons = new IIcon[4];

    public BlockSolarWindPanel() {
        super(Material.field_151573_f);
        this.func_149663_c("SolarWindPanel");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons[0] = reg.func_94245_a("galaxyspace:overworld/solarwind_basic_0");
        this.icons[1] = reg.func_94245_a("galaxyspace:overworld/solarwind_basic_1");
        this.icons[2] = reg.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.icons[3] = reg.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.getOrientation((int)(meta + 2)).getOpposite().ordinal()) {
            return this.icons[3];
        }
        if (side == ForgeDirection.UP.ordinal()) {
            return this.icons[0];
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.icons[2];
        }
        return this.icons[1];
    }

    public boolean func_149707_d(World worldIn, int x, int y, int z, int side) {
        for (int dY = 1; dY <= 2; ++dY) {
            for (int dX = -1; dX <= 1; ++dX) {
                for (int dZ = -1; dZ <= 1; ++dZ) {
                    Block block = worldIn.func_147439_a(x + (dY == 2 ? dX : 0), y + dY, z + (dY == 2 ? dZ : 0));
                    if (block.func_149688_o() == Material.field_151579_a || block.isReplaceable((IBlockAccess)worldIn, x + dX, y + dY, z + dZ)) continue;
                    return false;
                }
            }
        }
        return new BlockVec3(x, y, z).newVecSide(side ^ 1).getBlock((IBlockAccess)worldIn) != GCBlocks.fakeBlock;
    }

    @Override
    public void func_149689_a(World worldIn, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        super.func_149689_a(worldIn, x, y, z, placer, itemIn);
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntitySolarWind) {
            TileEntitySolarWind tileSolar = (TileEntitySolarWind)tileEntity;
            tileSolar.onCreate(new BlockVec3(x, y, z));
        }
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntitySolarWind) {
            TileEntitySolarWind tileSolar = (TileEntitySolarWind)tileEntity;
            tileSolar.onDestroy((TileEntity)tileSolar);
        }
        super.func_149749_a(worldIn, x, y, z, blockBroken, meta);
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntitySolarWind();
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public String getDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.coefficient.desc") + ": x" + GSConfigCore.coefficientSolarWindPanel;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.SolarWindPanel.desc");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        return true;
    }
}

