/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class SmithingTableRecipes {
    private static final SmithingTableRecipes instance = new SmithingTableRecipes();
    private final List<SmithingTableRecipe> recipes = new ArrayList<SmithingTableRecipe>();

    public static SmithingTableRecipes getInstance() {
        return instance;
    }

    public static void init() {
        if (ConfigBlocksItems.enableNetherite) {
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_PICKAXE.get()), "ingotNetherite", new ItemStack(Items.field_151046_w, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_AXE.get()), "ingotNetherite", new ItemStack(Items.field_151056_x, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_SPADE.get()), "ingotNetherite", new ItemStack(Items.field_151047_v, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_SWORD.get()), "ingotNetherite", new ItemStack(Items.field_151048_u, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_HOE.get()), "ingotNetherite", new ItemStack(Items.field_151012_L, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_HELMET.get()), "ingotNetherite", new ItemStack((Item)Items.field_151161_ac, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_CHESTPLATE.get()), "ingotNetherite", new ItemStack((Item)Items.field_151163_ad, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_LEGGINGS.get()), "ingotNetherite", new ItemStack((Item)Items.field_151173_ae, 1, Short.MAX_VALUE));
            SmithingTableRecipes.getInstance().addRecipe(new ItemStack(ModItems.NETHERITE_BOOTS.get()), "ingotNetherite", new ItemStack((Item)Items.field_151175_af, 1, Short.MAX_VALUE));
        }
    }

    public void addRecipe(ItemStack result, Object materialSlot, Object toolSlot) {
        SmithingTableRecipes.instance.recipes.add(new SmithingTableRecipe(toolSlot, materialSlot, result, true));
    }

    public void addRecipeNoNBT(ItemStack result, Object materialSlot, Object toolSlot) {
        SmithingTableRecipes.instance.recipes.add(new SmithingTableRecipe(toolSlot, materialSlot, result, false));
    }

    public void addRecipe(SmithingTableRecipe recipe) {
        SmithingTableRecipes.instance.recipes.add(recipe);
    }

    public List<SmithingTableRecipe> getRecipes() {
        return this.recipes;
    }

    public ItemStack findMatchingRecipe(InventoryCrafting p_82787_1_, World p_82787_2_) {
        for (SmithingTableRecipe recipe : this.recipes) {
            if (!recipe.func_77569_a(p_82787_1_, p_82787_2_)) continue;
            return recipe.func_77572_b(p_82787_1_);
        }
        return null;
    }

    public static class SmithingTableRecipe
    implements IRecipe {
        private final boolean copyNBT;
        private final Object input;
        private final Object material;
        private final ItemStack output;

        public SmithingTableRecipe(Object toolSlot, Object materialSlot, ItemStack result, boolean copy) {
            this.copyNBT = copy;
            this.output = result;
            Object[] recipe = new Object[]{toolSlot, materialSlot};
            for (int idx = 0; idx < 2; ++idx) {
                Object in = recipe[idx];
                if (in instanceof ItemStack) {
                    recipe[idx] = ((ItemStack)in).func_77946_l();
                    continue;
                }
                if (in instanceof Item) {
                    recipe[idx] = new ItemStack((Item)in);
                    continue;
                }
                if (in instanceof Block) {
                    recipe[idx] = new ItemStack((Block)in, 1, Short.MAX_VALUE);
                    continue;
                }
                if (in instanceof String) {
                    recipe[idx] = OreDictionary.getOres((String)((String)in));
                    continue;
                }
                String ret = "Invalid smithing table recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            this.input = recipe[0];
            this.material = recipe[1];
        }

        public ItemStack func_77572_b(InventoryCrafting var1) {
            ItemStack stack = this.output.func_77946_l();
            if (this.copyNBT) {
                ItemStack toCopy = var1.func_70301_a(0);
                if (toCopy.func_77942_o()) {
                    stack.func_77982_d(toCopy.func_77978_p());
                }
                if (toCopy.func_77984_f() && stack.func_77984_f()) {
                    stack.func_77964_b(toCopy.func_77960_j());
                }
            }
            return stack;
        }

        public int func_77570_a() {
            return 2;
        }

        public ItemStack func_77571_b() {
            return this.output;
        }

        public Object getInputItem() {
            return this.input;
        }

        public Object getMaterial() {
            return this.material;
        }

        public boolean func_77569_a(InventoryCrafting inv, World world) {
            Object[] recipe = new Object[]{this.input, this.material};
            for (int x = 0; x < 2; ++x) {
                Object target = recipe[x];
                ItemStack slot = inv.func_70301_a(x);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    Iterator itr = ((ArrayList)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
            return true;
        }
    }
}

