/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openmods.calc.Environment;
import openmods.calc.Frame;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.OptionalType;
import openmods.calc.types.multi.SimpleNamespace;
import openmods.calc.types.multi.SimpleTypedFunction;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypeUserdata;
import openmods.calc.types.multi.TypedFunction;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;

public class RegexSymbol {
    private static final String ATTR_MATCHER = "matcher";
    private static final String ATTR_MATCH = "match";
    private static final String ATTR_SEARCH = "search";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_MATCHED = "matched";
    private static final String ATTR_END = "end";
    private static final String ATTR_START = "start";

    private static TypedValue wrap(TypeDomain domain, int value) {
        return domain.create(BigInteger.class, BigInteger.valueOf(value));
    }

    private static TypedValue wrap(TypeDomain domain, String value) {
        return domain.create(String.class, value);
    }

    private static TypedValue wrap(TypeDomain domain, TypeUserdata value) {
        return domain.create(TypeUserdata.class, value);
    }

    private static void addFlag(Map<String, TypedValue> output, TypeDomain domain, int value, String ... names) {
        for (String name : names) {
            output.put(name, RegexSymbol.wrap(domain, value));
        }
    }

    private static MetaObject createPatternWrapperMetaObject(final TypeDomain domain, TypedValue patternType) {
        return MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                PatternWrapper patternWrapper = self.as(PatternWrapper.class);
                if (key.equals(RegexSymbol.ATTR_PATTERN)) {
                    return Optional.of((Object)domain.create(String.class, patternWrapper.pattern.pattern()));
                }
                if (key.equals(RegexSymbol.ATTR_FLAGS)) {
                    return Optional.of((Object)RegexSymbol.wrap(domain, patternWrapper.pattern.flags()));
                }
                if (key.equals(RegexSymbol.ATTR_SEARCH)) {
                    return Optional.of((Object)domain.create(MatcherWrapper.class, patternWrapper.search()));
                }
                if (key.equals(RegexSymbol.ATTR_MATCH)) {
                    return Optional.of((Object)domain.create(MatcherWrapper.class, patternWrapper.match()));
                }
                return Optional.absent();
            }
        }).set(MetaObjectUtils.dirFromArray(ATTR_PATTERN, ATTR_FLAGS, ATTR_SEARCH, ATTR_MATCH)).set(MetaObjectUtils.typeConst(patternType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return "compiled pattern: " + self.as(PatternWrapper.class).pattern.toString();
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return "regex(" + self.as(PatternWrapper.class).pattern.toString() + ")";
            }
        }).build();
    }

    private static MetaObject createMatcherWrapperMetaObject(final TypeDomain domain, TypedValue matcherType) {
        return MetaObject.builder().set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                argumentsCount.compareIfPresent(2);
                returnsCount.compareIfPresent(1);
                MatcherWrapper matcher = self.as(MatcherWrapper.class);
                String value = frame.stack().pop().as(String.class);
                Optional<MatchWrapper> match = matcher.match(value);
                TypedValue result = match.isPresent() ? OptionalType.present(domain, domain.create(MatchWrapper.class, match.get())) : OptionalType.absent(domain);
                frame.stack().push(result);
            }
        }).set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                Preconditions.checkArgument((variableCount == 1 ? 1 : 0) != 0, (String)"Invalid number of variables, expected one, got %s", (Object[])new Object[]{variableCount});
                MatcherWrapper matcher = self.as(MatcherWrapper.class);
                Optional<MatchWrapper> result = matcher.match(input.as(String.class));
                if (result.isPresent()) {
                    TypedValue wrappedResult = domain.create(MatchWrapper.class, result.get());
                    ImmutableList resultValues = ImmutableList.of((Object)wrappedResult);
                    return Optional.of((Object)resultValues);
                }
                return Optional.absent();
            }
        }).set(MetaObjectUtils.typeConst(matcherType)).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                MatcherWrapper s = self.as(MatcherWrapper.class);
                return s.type() + " matcher for pattern " + s.pattern.pattern();
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                MatcherWrapper s = self.as(MatcherWrapper.class);
                return "regex(" + s.pattern.toString() + ")." + s.type();
            }
        }).build();
    }

    private static MetaObject createMatchWrapperMetaObject(final TypeDomain domain, final TypedValue nullValue, TypedValue matchType) {
        return MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                MatchWrapper s = self.as(MatchWrapper.class);
                if (key.equals(RegexSymbol.ATTR_START)) {
                    return Optional.of((Object)RegexSymbol.wrap(domain, s.matcher.start()));
                }
                if (key.equals(RegexSymbol.ATTR_END)) {
                    return Optional.of((Object)RegexSymbol.wrap(domain, s.matcher.end()));
                }
                if (key.equals(RegexSymbol.ATTR_MATCHED)) {
                    return Optional.of((Object)RegexSymbol.wrap(domain, s.matcher.group()));
                }
                return Optional.absent();
            }
        }).set(MetaObjectUtils.dirFromArray(ATTR_START, ATTR_END, ATTR_MATCHED)).set(new MetaObject.SlotSlice(){

            @Override
            public TypedValue slice(TypedValue self, TypedValue range, Frame<TypedValue> frame) {
                int group = range.as(BigInteger.class).intValue();
                String groupContents = self.as(MatchWrapper.class).matcher.group(group);
                return groupContents != null ? domain.create(String.class, groupContents) : nullValue;
            }
        }).set(new MetaObject.SlotLength(){

            @Override
            public int length(TypedValue self, Frame<TypedValue> frame) {
                return self.as(MatchWrapper.class).matcher.groupCount();
            }
        }).set(MetaObjectUtils.typeConst(matchType)).build();
    }

    public static void register(Environment<TypedValue> env) {
        TypedValue nullValue = env.nullValue();
        TypeDomain domain = nullValue.domain;
        HashMap values = Maps.newHashMap();
        RegexSymbol.addFlag(values, domain, 2, "i", "case_insensitive");
        RegexSymbol.addFlag(values, domain, 8, "m", "multiline");
        RegexSymbol.addFlag(values, domain, 32, "s", "dotall");
        RegexSymbol.addFlag(values, domain, 4, "x", "comments");
        RegexSymbol.addFlag(values, domain, 1, "n", "unix_lines");
        TypedValue patternType = RegexSymbol.wrap(domain, new TypeUserdata("regex.pattern", PatternWrapper.class));
        values.put(ATTR_PATTERN, patternType);
        domain.registerType(PatternWrapper.class, "regex.pattern", RegexSymbol.createPatternWrapperMetaObject(domain, patternType));
        TypedValue matcherType = RegexSymbol.wrap(domain, new TypeUserdata("regex.matcher", MatcherWrapper.class));
        values.put(ATTR_MATCHER, matcherType);
        domain.registerType(MatcherWrapper.class, "regex.matcher", RegexSymbol.createMatcherWrapperMetaObject(domain, matcherType));
        TypedValue matchType = RegexSymbol.wrap(domain, new TypeUserdata("regex.match", MatchWrapper.class));
        values.put(ATTR_MATCH, matchType);
        domain.registerType(MatchWrapper.class, "regex.match", RegexSymbol.createMatchWrapperMetaObject(domain, nullValue, matchType));
        TypedValue regex = domain.create(SimpleNamespace.class, new SimpleNamespace(values), SimpleNamespace.defaultMetaObject().set(MetaObjectUtils.callableAdapter(new SimpleTypedFunction(domain){

            @TypedFunction.Variant
            public PatternWrapper create(String value, @TypedFunction.DispatchArg BigInteger flags) {
                Pattern pattern = Pattern.compile(value, flags.intValue());
                return new PatternWrapper(pattern);
            }

            @TypedFunction.Variant
            public PatternWrapper create(String value) {
                Pattern pattern = Pattern.compile(value);
                return new PatternWrapper(pattern);
            }
        })).build());
        env.setGlobalSymbol("regex", regex);
    }

    private static class MatchWrapper {
        public final MatchResult matcher;

        public MatchWrapper(MatchResult matcher) {
            this.matcher = matcher;
        }
    }

    private static class PartialMatcherWrapper
    extends MatcherWrapper {
        public PartialMatcherWrapper(Pattern pattern) {
            super(pattern);
        }

        @Override
        protected boolean check(Matcher matcher) {
            return matcher.find();
        }

        @Override
        public String type() {
            return RegexSymbol.ATTR_SEARCH;
        }
    }

    private static class FullMatcherWrapper
    extends MatcherWrapper {
        public FullMatcherWrapper(Pattern pattern) {
            super(pattern);
        }

        @Override
        protected boolean check(Matcher matcher) {
            return matcher.matches();
        }

        @Override
        public String type() {
            return RegexSymbol.ATTR_MATCH;
        }
    }

    private static abstract class MatcherWrapper {
        public final Pattern pattern;

        public MatcherWrapper(Pattern pattern) {
            this.pattern = pattern;
        }

        public abstract String type();

        protected abstract boolean check(Matcher var1);

        public Optional<MatchWrapper> match(String value) {
            Matcher matcher = this.pattern.matcher(value);
            if (this.check(matcher)) {
                return Optional.of((Object)new MatchWrapper(matcher.toMatchResult()));
            }
            return Optional.absent();
        }
    }

    private static class PatternWrapper {
        private final Pattern pattern;

        public PatternWrapper(Pattern pattern) {
            this.pattern = pattern;
        }

        public MatcherWrapper search() {
            return new PartialMatcherWrapper(this.pattern);
        }

        public MatcherWrapper match() {
            return new FullMatcherWrapper(this.pattern);
        }
    }
}

