/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.util;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;

public final class InetAddressRange {
    private final byte[] min;
    private final byte[] max;

    InetAddressRange(byte[] min2, byte[] max2) {
        this.min = min2;
        this.max = max2;
    }

    public boolean matches(InetAddress address) {
        byte[] entry = address.getAddress();
        if (entry.length != this.min.length) {
            return false;
        }
        for (int i = 0; i < entry.length; ++i) {
            int value = 0xFF & entry[i];
            if (value >= (0xFF & this.min[i]) && value <= (0xFF & this.max[i])) continue;
            return false;
        }
        return true;
    }

    public static InetAddressRange parse(String addressStr, String prefixSizeStr) {
        InetAddress address;
        int prefixSize;
        try {
            prefixSize = Integer.parseInt(prefixSizeStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Malformed address range entry '%s': Cannot extract size of CIDR mask from '%s'.", addressStr + '/' + prefixSizeStr, prefixSizeStr));
        }
        try {
            address = InetAddresses.forString((String)addressStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Malformed address range entry '%s': Cannot extract IP address from '%s'.", addressStr + '/' + prefixSizeStr, addressStr));
        }
        byte[] minBytes = address.getAddress();
        byte[] maxBytes = address.getAddress();
        int size2 = prefixSize;
        for (int i = 0; i < minBytes.length; ++i) {
            if (size2 <= 0) {
                minBytes[i] = 0;
                maxBytes[i] = -1;
            } else if (size2 < 8) {
                minBytes[i] = (byte)(minBytes[i] & 255 << 8 - size2);
                maxBytes[i] = (byte)(maxBytes[i] | ~(255 << 8 - size2));
            }
            size2 -= 8;
        }
        return new InetAddressRange(minBytes, maxBytes);
    }
}

