/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.handler;

import com.brandon3055.brandonscore.common.handlers.FileHandler;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.client.model.special.ModelContributorWings;
import com.brandon3055.draconicevolution.common.network.ContributorPacket;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import com.google.common.base.Charsets;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class ContributorHandler {
    public static Map<String, Contributor> contributors = new LinkedHashMap<String, Contributor>();
    public static boolean successfulLoad = false;
    private static DLThread thread;
    private static ModelContributorWings wings;

    public static void init() {
        thread = new DLThread();
        thread.start();
    }

    public static void render(RenderPlayerEvent.Specials event) {
        if (ContributorHandler.isPlayerContributor(event.entityPlayer)) {
            Contributor contributor = contributors.get(event.entityPlayer.func_70005_c_());
            if (contributor.contributionLevel >= 1 && contributor.contributorWingsEnabled) {
                ContributorHandler.renderWings((RenderPlayerEvent)event);
            }
            if (contributor.contribution != null && contributor.contribution.toLowerCase().contains("patreon") && contributor.patreonBadgeEnabled) {
                ContributorHandler.renderBadge((RenderPlayerEvent)event);
            }
        }
    }

    public static boolean isPlayerContributor(EntityPlayer player) {
        return contributors.containsKey(player.func_70005_c_()) && contributors.get(player.func_70005_c_()).isUserValid(player);
    }

    private static void renderWings(RenderPlayerEvent event) {
        ResourceHandler.bindResource("textures/models/ContributorWings.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        wings.func_78088_a((Entity)event.entityPlayer, 0.0f, 0.0f, 0.0f, 0.0f, event.partialRenderTick, 0.0625f);
    }

    private static void renderBadge(RenderPlayerEvent event) {
        ResourceHandler.bindResource("textures/special/PatreonBadge.png");
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        if (event.entityPlayer.func_70093_af()) {
            GL11.glRotatef((float)29.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        double x = 0.01;
        double y = 0.04;
        double z = -0.13;
        double xSize = 0.22;
        double ySize = 0.22;
        tess.func_78382_b();
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tess.func_78374_a(x, y, z, 0.0, 0.0);
        tess.func_78374_a(x, y + ySize, z, 0.0, 1.0);
        tess.func_78374_a(x + xSize, y + ySize, z, 1.0, 1.0);
        tess.func_78374_a(x + xSize, y, z, 1.0, 0.0);
        tess.func_78381_a();
        GL11.glDepthFunc((int)514);
        GL11.glDisable((int)2896);
        ResourceHandler.bindTexture(ResourceHandler.getResourceWOP("textures/misc/enchanted_item_glint.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)768, (int)1);
        float f11 = 0.76f;
        GL11.glColor4f((float)(0.9f * f11), (float)(0.8f * f11), (float)(0.1f * f11), (float)1.0f);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        float f12 = 0.125f;
        GL11.glScalef((float)f12, (float)f12, (float)f12);
        float f13 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
        GL11.glTranslatef((float)f13, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        tess.func_78382_b();
        tess.func_78374_a(x, y, z, 0.0, 0.0);
        tess.func_78374_a(x, y + ySize, z, 0.0, 1.0);
        tess.func_78374_a(x + xSize, y + ySize, z, 1.0, 1.0);
        tess.func_78374_a(x + xSize, y, z, 1.0, 0.0);
        tess.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)f12, (float)f12, (float)f12);
        f13 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
        GL11.glTranslatef((float)(-f13), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        tess.func_78382_b();
        tess.func_78374_a(x, y, z, 0.0, 0.0);
        tess.func_78374_a(x, y + ySize, z, 0.0, 1.0);
        tess.func_78374_a(x + xSize, y + ySize, z, 1.0, 1.0);
        tess.func_78374_a(x + xSize, y, z, 1.0, 0.0);
        tess.func_78381_a();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
        GL11.glPopMatrix();
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            for (String contribName : contributors.keySet()) {
                for (String name : FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z()) {
                    if (!name.equals(contribName)) continue;
                    Contributor contributor = contributors.get(contribName);
                    DraconicEvolution.network.sendTo((IMessage)new ContributorPacket(contribName, contributor.contributorWingsEnabled, contributor.patreonBadgeEnabled), (EntityPlayerMP)event.player);
                }
            }
        }
    }

    private static void readFile() {
        File cFile = new File(FileHandler.configFolder, "/draconicevolution/contributors.json");
        if (!cFile.exists()) {
            LogHelper.error("Could not find contributors file");
            return;
        }
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(cFile));
            reader.setLenient(true);
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                Contributor contributor = new Contributor();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("name")) {
                        contributor.name = reader.nextString();
                        continue;
                    }
                    if (name.equals("ign")) {
                        contributor.ign = reader.nextString();
                        continue;
                    }
                    if (name.equals("contribution")) {
                        contributor.contribution = reader.nextString();
                        continue;
                    }
                    if (name.equals("details")) {
                        contributor.details = reader.nextString();
                        continue;
                    }
                    if (name.equals("website")) {
                        contributor.website = reader.nextString();
                        continue;
                    }
                    if (!name.equals("contributionLevel")) continue;
                    contributor.contributionLevel = reader.nextInt();
                }
                contributors.put(contributor.ign, contributor);
                reader.endObject();
            }
            reader.endArray();
            reader.close();
            cFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void tick() {
        if (thread == null) {
            return;
        }
        if (thread.isFinished()) {
            thread = null;
            ContributorHandler.readFile();
            successfulLoad = true;
        } else if (thread.isFailed()) {
            thread = null;
        }
    }

    static {
        wings = new ModelContributorWings();
    }

    public static class DLThread
    extends Thread {
        private boolean finished = false;
        private boolean failed = false;

        public DLThread() {
            super("DE Contributors DL Thread");
        }

        @Override
        public void run() {
            super.run();
            try {
                URL url = new URL("http://www.brandon3055.com/json/DEContributors.json");
                File cFile = new File(FileHandler.configFolder, "/draconicevolution/contributors.json");
                InputStream is = url.openStream();
                FileOutputStream os = new FileOutputStream(cFile);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                is.close();
                ((OutputStream)os).close();
                this.finished = true;
            }
            catch (Exception e) {
                LogHelper.error("Failed to download contributors list");
                this.failed = true;
                e.printStackTrace();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public static class Contributor {
        public String name;
        public String ign;
        public String contribution;
        public String details;
        public String website;
        public int contributionLevel;
        public boolean contributorWingsEnabled = true;
        public boolean patreonBadgeEnabled = true;
        private boolean validated = false;
        private boolean isValid;

        public boolean isUserValid(EntityPlayer player) {
            if (!this.validated) {
                this.isValid = !UUID.nameUUIDFromBytes(("OfflinePlayer:" + player.func_70005_c_()).getBytes(Charsets.UTF_8)).equals(player.func_110124_au());
            }
            return this.isValid;
        }

        public String toString() {
            return "[Contributor: " + this.name + ", Contribution: " + this.contribution + ", Details: " + this.details + ", Website: " + this.website + "]";
        }
    }
}

