/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.structurelib;

import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.client.utils.ConstructableData;
import blockrenderer6343.client.world.ObserverWorld;
import blockrenderer6343.integration.nei.StructureHacks;
import com.google.common.collect.Iterables;
import com.gtnewhorizon.structurelib.StructureEvent;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class MultiblockInfoContainerScan
implements Runnable {
    private static final String IDENTIFIER = "IMultiBlockInfoContainerScan";
    private final Consumer<Long2ObjectMap<ObjectSet<IConstructable>>> resultCallback;
    private final Consumer<Object2ObjectMap<IConstructable, ItemStack>> stackCallback;
    private final Map<String, IMultiblockInfoContainer<TileEntity>> infoContainers;
    private final Long2ObjectMap<ObjectSet<IConstructable>> result = new Long2ObjectOpenHashMap();
    private final ObjectSet<IStructureElement<?>> checkedElements = new ObjectOpenHashSet();
    private final ObserverWorld world = new ObserverWorld();
    private IConstructable currentConstructable;
    private ConstructableData currentData = new ConstructableData();

    public MultiblockInfoContainerScan(Consumer<Long2ObjectMap<ObjectSet<IConstructable>>> resultCallback, Consumer<Object2ObjectMap<IConstructable, ItemStack>> stackCallback, Map<String, IMultiblockInfoContainer<?>> infoContainers) {
        this.resultCallback = resultCallback;
        this.stackCallback = stackCallback;
        this.infoContainers = infoContainers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IMultiblockInfoContainer)e.getValue()));
    }

    @Override
    public void run() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (!StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.enableInstrument((Object)IDENTIFIER);
        }
        Object2ObjectOpenHashMap stacks = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap constructableData = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, IMultiblockInfoContainer<TileEntity>> entry : this.infoContainers.entrySet()) {
            this.currentConstructable = this.world.getConstructableFromContainer(entry.getKey(), entry.getValue());
            int tier = this.world.estimateTierFromInfoContainer(this.result, (Object2ObjectMap<IConstructable, ItemStack>)stacks, this.currentConstructable);
            if (tier > 1) {
                this.currentData.setMaxTier(tier, "");
            }
            if (!this.currentData.hasData()) continue;
            constructableData.put((Object)this.currentConstructable, (Object)this.currentData);
            this.currentData = new ConstructableData();
        }
        ConstructableData.addConstructableData((Object2ObjectMap<IConstructable, ConstructableData>)constructableData);
        this.stackCallback.accept((Object2ObjectMap<IConstructable, ItemStack>)stacks);
        this.resultCallback.accept(this.result);
        if (StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.disableInstrument();
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void OnStructureEvent(StructureEvent.StructureElementVisitedEvent event) {
        if (!IDENTIFIER.equals(event.getInstrumentIdentifier()) || !this.checkedElements.add((Object)event.getElement())) {
            return;
        }
        TileEntity tile = this.world.func_147438_o(0, 64, 0);
        Iterable<ItemStack> stacks = StructureHacks.getStacksForElement(tile, event.getElement(), this.currentData);
        if (stacks == null || Iterables.isEmpty(stacks)) {
            return;
        }
        for (ItemStack stack : stacks) {
            if (!StructureHacks.isSafeStack(stack)) continue;
            ((ObjectSet)this.result.computeIfAbsent(BRUtil.hashStack(stack), k -> new ObjectOpenHashSet())).add((Object)this.currentConstructable);
        }
    }
}

