/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.enums;

import codechicken.nei.api.API;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ItemList implements IItemContainer
{
    ExtremeEntityCrusher,
    ExtremeIndustrialApiary,
    ExtremeIndustrialGreenhouse,
    DraconicEvolutionFusionCrafter,
    LegendaryBlackTea,
    LegendaryButterflyTea,
    LegendaryEarlGrayTea,
    LegendaryGreenTea,
    LegendaryLemonTea,
    LegendaryMilkTea,
    LegendaryOolongTea,
    LegendaryPeppermintTea,
    LegendaryPuerhTea,
    LegendaryRedTea,
    LegendaryWhiteTea,
    LegendaryYellowTea,
    LegendaryUltimateTea,
    BlackTea,
    EarlGrayTea,
    GreenTea,
    LemonTea,
    MilkTea,
    OolongTea,
    PeppermintTea,
    PuerhTea,
    WhiteTea,
    YellowTea,
    BlackTeaLeaf,
    GreenTeaLeaf,
    OolongTeaLeaf,
    PuerhTeaLeaf,
    WhiteTeaLeaf,
    YellowTeaLeaf,
    TeaLeafDehydrated,
    SteamedTeaLeaf,
    RolledTeaLeaf,
    OxidizedTeaLeaf,
    FermentedTeaLeaf,
    BruisedTeaLeaf,
    PartiallyOxidizedTeaLeaf,
    TeaAcceptorResearchNote,
    TeaAcceptor,
    TeaStorage,
    Beeeeee,
    DEFCCasingBase,
    DEFCCasingT1,
    DEFCCasingT2,
    DEFCCasingT3,
    DEFCCasingT4,
    DEFCCasingT5,
    DEFCDraconicSchematic,
    DEFCWyvernSchematic,
    DEFCAwakenedSchematic,
    DEFCChaoticSchematic;

    @Nullable
    private ItemStack mStack;
    private boolean mHasNotBeenSet = true;

    @Override
    @NotNull
    public IItemContainer set(@Nullable Item aItem) {
        this.mHasNotBeenSet = false;
        if (aItem == null) {
            return this;
        }
        ItemStack aStack = new ItemStack(aItem, 1, 0);
        this.mStack = GTUtility.copyAmount(1, aStack);
        return this;
    }

    @Override
    @NotNull
    public IItemContainer set(@NotNull ItemStack aStack) {
        this.mHasNotBeenSet = false;
        this.mStack = GTUtility.copyAmount(1, aStack);
        return this;
    }

    @Override
    @NotNull
    public IItemContainer hidden() {
        API.hideItem((ItemStack)this.get(1L, new Object[0]));
        return this;
    }

    @Override
    @Nullable
    public Item getItem() {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid(this.mStack)) {
            return null;
        }
        return this.mStack.func_77973_b();
    }

    @Override
    public Block getBlock() {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        return GTUtility.getBlockFromItem(this.getItem());
    }

    @Override
    public final boolean hasBeenSet() {
        return !this.mHasNotBeenSet;
    }

    @Override
    public boolean isStackEqual(Object aStack) {
        return this.isStackEqual(aStack, false, false);
    }

    @Override
    public boolean isStackEqual(Object aStack, boolean aWildcard, boolean aIgnoreNBT) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        return GTUtility.areUnificationsEqual((ItemStack)aStack, aWildcard ? this.getWildcard(1L, new Object[0]) : this.get(1L, new Object[0]), aIgnoreNBT);
    }

    @Override
    public ItemStack get(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid(this.mStack)) {
            return GTUtility.copyAmount(aAmount, aReplacements);
        }
        return GTUtility.copyAmount(aAmount, GTOreDictUnificator.get(this.mStack));
    }

    @Override
    public ItemStack getWildcard(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid(this.mStack)) {
            return GTUtility.copyAmount(aAmount, aReplacements);
        }
        return GTUtility.copyAmountAndMetaData(aAmount, 32767L, GTOreDictUnificator.get(this.mStack));
    }

    @Override
    public ItemStack getUndamaged(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid(this.mStack)) {
            return GTUtility.copyAmount(aAmount, aReplacements);
        }
        return GTUtility.copyAmountAndMetaData(aAmount, 0L, GTOreDictUnificator.get(this.mStack));
    }

    @Override
    public ItemStack getAlmostBroken(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid(this.mStack)) {
            return GTUtility.copyAmount(aAmount, aReplacements);
        }
        return GTUtility.copyAmountAndMetaData(aAmount, (long)(this.mStack.func_77958_k() - 1), GTOreDictUnificator.get(this.mStack));
    }

    @Override
    @Nullable
    public ItemStack getWithName(long aAmount, @NotNull String aDisplayName, Object ... aReplacements) {
        String[] tDisplayNameWords;
        ItemStack rStack = this.get(1L, aReplacements);
        if (GTUtility.isStackInvalid(rStack)) {
            return GTValues.NI;
        }
        StringBuilder tCamelCasedDisplayNameBuilder = new StringBuilder();
        for (String tWord : tDisplayNameWords = aDisplayName.split("\\W")) {
            if (!tWord.isEmpty()) {
                tCamelCasedDisplayNameBuilder.append(tWord.substring(0, 1).toUpperCase(Locale.US));
            }
            if (tWord.length() <= 1) continue;
            tCamelCasedDisplayNameBuilder.append(tWord.substring(1).toLowerCase(Locale.US));
        }
        if (tCamelCasedDisplayNameBuilder.length() == 0) {
            tCamelCasedDisplayNameBuilder.append((Object)aDisplayName.hashCode());
        }
        String tKey = rStack.func_77977_a() + ".with." + tCamelCasedDisplayNameBuilder + ".name";
        rStack.func_151001_c(GTLanguageManager.addStringLocalization(tKey, aDisplayName));
        return GTUtility.copyAmount(aAmount, rStack);
    }

    @Override
    @Nullable
    public ItemStack getWithCharge(long aAmount, int aEnergy, Object ... aReplacements) {
        ItemStack rStack = this.get(1L, aReplacements);
        if (GTUtility.isStackInvalid(rStack)) {
            return null;
        }
        GTModHandler.chargeElectricItem(rStack, aEnergy, Integer.MAX_VALUE, true, false);
        return GTUtility.copyAmount(aAmount, rStack);
    }

    @Override
    public ItemStack getWithDamage(long aAmount, long aMetaValue, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid(this.mStack)) {
            return GTUtility.copyAmount(aAmount, aReplacements);
        }
        return GTUtility.copyAmountAndMetaData(aAmount, aMetaValue, GTOreDictUnificator.get(this.mStack));
    }

    @Override
    @NotNull
    public IItemContainer registerOre(Object ... aOreNames) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        for (Object tOreName : aOreNames) {
            GTOreDictUnificator.registerOre(tOreName, this.get(1L, new Object[0]));
        }
        return this;
    }

    @Override
    @NotNull
    public IItemContainer registerWildcardAsOre(Object ... aOreNames) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        for (Object tOreName : aOreNames) {
            GTOreDictUnificator.registerOre(tOreName, this.getWildcard(1L, new Object[0]));
        }
        return this;
    }

    public ItemStack getInternalStack_unsafe() {
        return this.mStack;
    }
}

