/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.recipe.maps;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import gtnhintergalactic.recipe.IGRecipeMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpaceResearchFrontend
extends RecipeMapFrontend {
    public SpaceResearchFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter(new SpaceResearchSpecialValueFormatter()));
    }

    @Override
    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return Collections.singletonList(new Pos2d(142, 35));
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        ArrayList<Pos2d> inputPositions = new ArrayList<Pos2d>();
        inputPositions.add(new Pos2d(80, 35));
        inputPositions.add(new Pos2d(62, 8));
        inputPositions.add(new Pos2d(80, 8));
        inputPositions.add(new Pos2d(98, 8));
        inputPositions.add(new Pos2d(62, 60));
        inputPositions.add(new Pos2d(80, 60));
        inputPositions.add(new Pos2d(98, 60));
        return inputPositions;
    }

    @Override
    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions(fluidInputCount, 34, 17, 1);
    }

    private static class SpaceResearchSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private SpaceResearchSpecialValueFormatter() {
        }

        @Override
        public List<String> format(RecipeDisplayInfo recipeInfo) {
            ArrayList<String> specialInfo = new ArrayList<String>();
            specialInfo.add(GCCoreUtil.translateWithFormat((String)"tt.nei.research.min_computation", (Object[])new Object[]{recipeInfo.recipe.mSpecialValue}));
            String neededProject = recipeInfo.recipe.getMetadata(IGRecipeMaps.SPACE_PROJECT);
            String neededProjectLocation = recipeInfo.recipe.getMetadata(IGRecipeMaps.SPACE_LOCATION);
            if (neededProject != null && !neededProject.isEmpty()) {
                specialInfo.add(String.format(GCCoreUtil.translate((String)"ig.nei.spaceassembler.project"), SpaceProjectManager.getProject(neededProject).getLocalizedName()));
                specialInfo.add(String.format(GCCoreUtil.translate((String)"ig.nei.spaceassembler.projectAt"), neededProjectLocation == null || neededProjectLocation.isEmpty() ? GCCoreUtil.translate((String)"ig.nei.spaceassembler.projectAnyLocation") : GCCoreUtil.translate((String)SpaceProjectManager.getLocation(neededProjectLocation).getUnlocalizedName())));
            }
            return specialInfo;
        }
    }
}

