/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.tinkers.util;

import gtPlusPlus.core.material.Material;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.util.IPattern;
import tconstruct.smeltery.TinkerSmeltery;

public class TinkersUtils {
    public static void addSmelteryFuel(Fluid fluid, int power, int duration) {
        Smeltery.addSmelteryFuel((Fluid)fluid, (int)power, (int)duration);
    }

    public static boolean registerFluidType(String name, Block block, int meta, int baseTemperature, Fluid fluid, boolean isToolpart) {
        FluidType.registerFluidType((String)name, (Block)block, (int)meta, (int)baseTemperature, (Fluid)fluid, (boolean)isToolpart);
        return true;
    }

    public static void addMelting(ItemStack input, Block block, int metadata, int temperature, FluidStack liquid) {
        Smeltery.addMelting((ItemStack)input, (Block)block, (int)metadata, (int)temperature, (FluidStack)liquid);
    }

    public static void addMelting(FluidType type, ItemStack input, int temperatureDifference, int fluidAmount) {
        Smeltery.addMelting((FluidType)type, (ItemStack)input, (int)temperatureDifference, (int)fluidAmount);
    }

    public static void addBasinRecipe(ItemStack output, FluidStack metal, ItemStack cast, boolean consume, int delay) {
        LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
        tableCasting.addCastingRecipe(output, metal, cast, consume, delay);
    }

    public static void addCastingTableRecipe(ItemStack output, FluidStack metal, ItemStack cast, boolean consume, int delay) {
        LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
        basinCasting.addCastingRecipe(output, metal, cast, consume, delay);
    }

    public static List<CastingRecipe> getTableCastingRecipes() {
        LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
        return tableCasting.getCastingRecipes();
    }

    public static void generateCastingRecipes(Material aMaterial, int aID) {
        Fluid aMoltenIron = TinkerSmeltery.moltenIronFluid;
        FluidType fluidType = FluidType.getFluidType((String)aMaterial.getLocalizedName());
        for (CastingRecipe recipe : TinkersUtils.getTableCastingRecipes()) {
            CastingRecipeHandler newRecipe = new CastingRecipeHandler(recipe);
            if (newRecipe.castingMetal.getFluid() != aMoltenIron || newRecipe.cast == null || !(newRecipe.cast.func_77973_b() instanceof IPattern) || !(newRecipe.getResult().func_77973_b() instanceof DynamicToolPart)) continue;
            ItemStack output = newRecipe.getResult().func_77946_l();
            output.func_77964_b(aID);
            FluidStack liquid = new FluidStack(aMaterial.getFluidStack(0).getFluid(), newRecipe.castingMetal.amount);
            TinkersUtils.addCastingTableRecipe(output, liquid, newRecipe.cast, newRecipe.consumeCast, newRecipe.coolTime);
            TinkersUtils.addMelting(fluidType, output, 0, liquid.amount / 2);
        }
    }

    public static ItemStack getPattern(int aType) {
        return new ItemStack(TinkerSmeltery.metalPattern, aType, 0);
    }

    private static class CastingRecipeHandler {
        public ItemStack output;
        public FluidStack castingMetal;
        public ItemStack cast;
        public boolean consumeCast;
        public int coolTime;

        public CastingRecipeHandler(CastingRecipe castingRecipe) {
            this.output = castingRecipe.output;
            this.castingMetal = castingRecipe.castingMetal;
            this.cast = castingRecipe.cast;
            this.consumeCast = castingRecipe.consumeCast;
            this.coolTime = castingRecipe.coolTime;
        }

        public ItemStack getResult() {
            return this.output.func_77946_l();
        }
    }
}

