/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamCentrifuge
extends MTESteamMultiBase<MTESteamCentrifuge>
implements ISurvivalConstructable {
    private static final String STRUCTUR_PIECE_MAIN = "main";
    private IStructureDefinition<MTESteamCentrifuge> STRUCTURE_DEFINITION = null;
    private final String[][] shape = new String[][]{{" AAA ", "AAAAA", "AAAAA", "AAAAA", " AAA "}, {"     ", " ABA ", " BDB ", " ABA ", "     "}, {"  A  ", " ACA ", "ACDCA", " ACA ", "  A  "}, {" A~A ", "AABAA", "ABDBA", "AABAA", " AAA "}, {" AAA ", "AAAAA", "AAAAA", "AAAAA", " AAA "}};
    private static final int HORIZONTAL_OFF_SET = 2;
    private static final int VERTICAL_OFF_SET = 3;
    private static final int DEPTH_OFF_SET = 0;
    private int tierGearBoxCasing = -1;
    private int tierPipeCasing = -1;
    private int tierFireBoxCasing = -1;
    private int tierMachineCasing = -1;
    private int tCountCasing = 0;
    private int tierMachine = 1;

    public MTESteamCentrifuge(String aName) {
        super(aName);
    }

    public MTESteamCentrifuge(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamCentrifuge(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Centrifuge";
    }

    public Integer getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            ++this.tCountCasing;
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            ++this.tCountCasing;
            return 2;
        }
        return null;
    }

    @Nullable
    public static Integer getTierFireBoxCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings3 && 13 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings3 && 14 == meta) {
            return 2;
        }
        return null;
    }

    @Nullable
    public static Integer getTierGearBoxCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 2 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 3 == meta) {
            return 2;
        }
        return null;
    }

    @Nullable
    public static Integer getTierPipeCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 12 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 13 == meta) {
            return 2;
        }
        return null;
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mOutputHatches) {
            h.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        if (this.tierGearBoxCasing == 2 || this.tierPipeCasing == 2 || this.tierFireBoxCasing == 2 || this.tierMachineCasing == 2) {
            return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
        }
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.tierMachineCasing = aValue;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.tierMachineCasing;
    }

    @Override
    protected ITexture getFrontOverlay() {
        return TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_CENTRIFUGE).extFacing().build();
    }

    @Override
    protected ITexture getFrontOverlayActive() {
        return TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_CENTRIFUGE_ACTIVE).extFacing().build();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID())};
    }

    @Override
    public IStructureDefinition<MTESteamCentrifuge> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTUR_PIECE_MAIN, StructureUtility.transpose((String[][])this.shape)).addElement('B', StructureUtility.ofBlocksTiered(MTESteamCentrifuge::getTierGearBoxCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)3)), (Object)-1, (t, m) -> {
                t.tierGearBoxCasing = m;
            }, t -> t.tierGearBoxCasing)).addElement('C', StructureUtility.ofBlocksTiered(MTESteamCentrifuge::getTierPipeCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
                t.tierPipeCasing = m;
            }, t -> t.tierPipeCasing)).addElement('D', StructureUtility.ofBlocksTiered(MTESteamCentrifuge::getTierFireBoxCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings3, (Object)13), (Object)Pair.of((Object)GregTechAPI.sBlockCasings3, (Object)14)), (Object)-1, (t, m) -> {
                t.tierFireBoxCasing = m;
            }, t -> t.tierFireBoxCasing)).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamCentrifuge.buildSteamInput(MTESteamCentrifuge.class).casingIndex(10).dot(1).build(), GTStructureUtility.buildHatchAdder(MTESteamCentrifuge.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam, HatchElement.OutputHatch).casingIndex(10).dot(1).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlocksTiered(this::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTUR_PIECE_MAIN, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTUR_PIECE_MAIN, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierGearBoxCasing = -1;
        this.tierPipeCasing = -1;
        this.tierFireBoxCasing = -1;
        this.tierMachineCasing = -1;
        this.tCountCasing = 0;
        if (!this.checkPiece(STRUCTUR_PIECE_MAIN, 2, 3, 0)) {
            return false;
        }
        if (this.tierGearBoxCasing == 1 && this.tierPipeCasing == 1 && this.tierFireBoxCasing == 1 && this.tierMachineCasing == 1 && this.tCountCasing >= 60 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 1;
            return true;
        }
        if (this.tierGearBoxCasing == 2 && this.tierPipeCasing == 2 && this.tierFireBoxCasing == 2 && this.tierMachineCasing == 2 && this.tCountCasing >= 60 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 2;
            return true;
        }
        return false;
    }

    private boolean checkHatches() {
        return !this.mSteamInputFluids.isEmpty() && !this.mSteamInputs.isEmpty() && !this.mSteamOutputs.isEmpty() && !this.mOutputHatches.isEmpty() && this.mInputHatches.isEmpty();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.centrifugeRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamCentrifuge.this.tierMachine).setDurationModifier(1.6 / (double)MTESteamCentrifuge.this.tierMachine);
            }
        }.noRecipeCaching().setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("25% faster than using single block steam machines of the same pressure").addInfo("Only consumes steam at 62.5% of the steam flowrate normally required").addInfo("Processes up to 8 items at once").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").beginStructureBlock(5, 5, 5, false).addSteamInputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addSteamOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addOutputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addStructureInfo(EnumChatFormatting.WHITE + "Steam Input Hatch " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "Basic " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "60-65x" + EnumChatFormatting.GRAY + " Bronze Plated Bricks").addStructureInfo(EnumChatFormatting.GOLD + "8x" + EnumChatFormatting.GRAY + " Bronze Gear Box Casing").addStructureInfo(EnumChatFormatting.GOLD + "3x" + EnumChatFormatting.GRAY + " Bronze Firebox Casing").addStructureInfo(EnumChatFormatting.GOLD + "4x" + EnumChatFormatting.GRAY + " Bronze Pipe Casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "High Pressure " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "60-65x" + EnumChatFormatting.GRAY + " Solid Steel Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "8x" + EnumChatFormatting.GRAY + " Steel Gear Box Casing").addStructureInfo(EnumChatFormatting.GOLD + "3x" + EnumChatFormatting.GRAY + " Steel Firebox Casing").addStructureInfo(EnumChatFormatting.GOLD + "4x" + EnumChatFormatting.GRAY + " Steel Pipe Casing").toolTipFinisher(GTValues.AuthorEvgenWarGold);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi.steam.tier", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.tierMachine}));
        info.add(StatCollector.func_74837_a((String)"gtpp.infodata.multi.steam.parallel", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.getTrueParallel()}));
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamCentrifuge.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.tierMachine);
        tag.func_74768_a("parallel", this.getMaxParallelRecipes());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.tierMachine);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.tierMachine = aNBT.func_74762_e("tierMachine");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_STEAM_CENTRIFUGE_LOOP;
    }
}

