/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.Pair;

public class MTEIndustrialForgeHammer
extends GTPPMultiBlockBase<MTEIndustrialForgeHammer>
implements ISurvivalConstructable {
    private int mCasing;
    private int mAnvilTier = 0;
    private static IStructureDefinition<MTEIndustrialForgeHammer> STRUCTURE_DEFINITION = null;

    public MTEIndustrialForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialForgeHammer(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialForgeHammer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Forge Hammer";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Speed: +100% | EU Usage: 100% | Parallel: Tier x Anvil Tier x 8").addInfo("T1 - Vanilla Anvil");
        if (Mods.Railcraft.isModLoaded()) {
            tt.addInfo("T2 - Steel Anvil");
        }
        if (Mods.EnderIO.isModLoaded()) {
            tt.addInfo("T3 - Dark Steel Anvil");
        }
        if (Mods.ThaumicBases.isModLoaded()) {
            tt.addInfo("T3 - Thaumium Anvil");
            tt.addInfo("T4 - Void Metal Anvil");
        }
        tt.addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("Forge Casing", 6, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"GTPP.tooltip.structure.anvil"), "In the center of 3x3x3 structure", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialForgeHammer> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            HashMap<Block, Integer> anvilTiers = new HashMap<Block, Integer>();
            anvilTiers.put(Blocks.field_150467_bQ, 1);
            if (Mods.Railcraft.isModLoaded()) {
                anvilTiers.put(GameRegistry.findBlock((String)Mods.Railcraft.ID, (String)"anvil"), 2);
            }
            if (Mods.EnderIO.isModLoaded()) {
                anvilTiers.put(GameRegistry.findBlock((String)Mods.EnderIO.ID, (String)"blockDarkSteelAnvil"), 3);
            }
            if (Mods.ThaumicBases.isModLoaded()) {
                anvilTiers.put(GameRegistry.findBlock((String)Mods.ThaumicBases.ID, (String)"thaumicAnvil"), 3);
                anvilTiers.put(GameRegistry.findBlock((String)Mods.ThaumicBases.ID, (String)"voidAnvil"), 4);
            }
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "CAC", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialForgeHammer.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(TAE.getIndexFromPage(1, 11)).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)6)))).addElement('A', StructureUtility.ofBlocksTiered(MTEIndustrialForgeHammer.anvilTierConverter(anvilTiers), MTEIndustrialForgeHammer.getAllAnvilTiers(anvilTiers), (Object)0, MTEIndustrialForgeHammer::setAnvilTier, MTEIndustrialForgeHammer::getAnvilTier)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private static List<Pair<Block, Integer>> getAllAnvilTiers(Map<Block, Integer> anvilTiers) {
        return anvilTiers.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(e -> Pair.of((Object)((Block)e.getKey()), (Object)((Integer)e.getValue()))).collect(Collectors.toList());
    }

    private static ITierConverter<Integer> anvilTierConverter(Map<Block, Integer> anvilTiers) {
        return (block, meta) -> block == null ? null : (Integer)anvilTiers.getOrDefault(block, null);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.RANDOM_ANVIL_USE;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialForgeHammerActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialForgeHammerActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialForgeHammer;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialForgeHammerGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(1, 11);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.hammerRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().noRecipeCaching().setSpeedBonus(0.5).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * this.getAnvilTier() * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialForgeHammer;
    }

    private void setAnvilTier(int tier) {
        this.mAnvilTier = tier;
    }

    private int getAnvilTier() {
        return this.mAnvilTier;
    }
}

