/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.INEIPreviewModifier;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.RenderOverlay;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTUtilityClient;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEIndustrialCentrifuge
extends GTPPMultiBlockBase<MTEIndustrialCentrifuge>
implements ISurvivalConstructable,
INEIPreviewModifier {
    private boolean mIsAnimated = true;
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialCentrifuge> STRUCTURE_DEFINITION = null;
    protected final List<RenderOverlay.OverlayTicket> overlayTickets = new ArrayList<RenderOverlay.OverlayTicket>();
    protected boolean mFormed;

    public MTEIndustrialCentrifuge(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialCentrifuge(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialCentrifuge(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Centrifuge";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("125% faster than using single block machines of the same voltage").addInfo("Disable animations with a screwdriver").addInfo("Only uses 90% of the EU/t normally required").addInfo("Processes six items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("Centrifuge Casings", 6, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialCentrifuge> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialCentrifuge.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)0)))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        if (this.usingAnimations()) {
            return Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5;
        }
        return this.getInactiveOverlay();
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.LARGETURBINE_NEW5;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.setTurbineOverlay();
    }

    @Override
    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        boolean extendedFacingChanged = newExtendedFacing != this.getExtendedFacing();
        super.setExtendedFacing(newExtendedFacing);
        if (extendedFacingChanged) {
            this.setTurbineOverlay();
        }
    }

    @Override
    public void onTextureUpdate() {
        this.setTurbineOverlay();
    }

    protected void setTurbineOverlay() {
        IGregTechTileEntity tile = this.getBaseMetaTileEntity();
        if (tile.isServerSide()) {
            return;
        }
        IIconContainer[] tTextures = this.getBaseMetaTileEntity().isActive() && this.usingAnimations() ? Textures.BlockIcons.TURBINE_NEW_ACTIVE : Textures.BlockIcons.TURBINE_NEW;
        GTUtilityClient.setTurbineOverlay(tile.getWorld(), tile.getXCoord(), tile.getYCoord(), tile.getZCoord(), this.getExtendedFacing(), tTextures, this.overlayTickets);
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(0);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.centrifugeNonCellRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().noRecipeCaching().setEuModifier(0.9f).setSpeedBonus(0.4444444477558136).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 6 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasingsMisc;
    }

    public byte getCasingMeta() {
        return 0;
    }

    public byte getCasingTextureIndex() {
        return (byte)TAE.GTPP_INDEX(0);
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialCentrifuge;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mIsAnimated = !this.mIsAnimated;
        Logger.INFO("Is Centrifuge animated " + this.mIsAnimated);
        if (this.mIsAnimated) {
            GTUtility.sendChatToPlayer(aPlayer, "Using Animated Turbine Texture. ");
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "Using Static Turbine Texture. ");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mIsAnimated", this.mIsAnimated);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mIsAnimated = aNBT.func_74764_b("mIsAnimated") ? aNBT.func_74767_n("mIsAnimated") : true;
    }

    public boolean usingAnimations() {
        return this.mIsAnimated;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mFormed = (aValue & 1) != 0;
        this.setTurbineOverlay();
    }

    @Override
    public byte getUpdateData() {
        return (byte)(this.mMachine ? 1 : 0);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getBaseMetaTileEntity().isClientSide()) {
            GTUtilityClient.clearTurbineOverlay(this.overlayTickets);
        }
    }

    @Override
    public void onPreviewStructureComplete(@NotNull ItemStack trigger) {
        this.mFormed = true;
    }
}

