/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gregtech.api.hazards.HazardProtection;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.handler.events.EntityDeathHandler;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityUtils {
    public static void setEntityOnFire(Entity aEntity, int length) {
        if (!EntityUtils.isEntityImmuneToFire(aEntity)) {
            aEntity.func_70015_d(length);
        }
    }

    public static boolean isEntityImmuneToFire(Entity aEntity) {
        return aEntity.func_70045_F();
    }

    public static BlockPos findBlockPosUnderEntity(Entity parEntity) {
        int blockX = MathHelper.func_76128_c((double)parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)parEntity.field_70121_D.field_72338_b) - 1;
        int blockZ = MathHelper.func_76128_c((double)parEntity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ, parEntity.field_70170_p);
    }

    public static BlockPos findBlockPosOfEntity(Entity parEntity) {
        int blockX = MathHelper.func_76128_c((double)parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)parEntity.field_70121_D.field_72338_b);
        int blockZ = MathHelper.func_76128_c((double)parEntity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ, parEntity.field_70170_p);
    }

    public static void applyRadiationDamageToEntity(int stackSize, int radiationLevel, World world, Entity entityHolding) {
        if (!world.field_72995_K && radiationLevel > 0 && entityHolding instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityHolding;
            if (!(((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d || ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)entityLiving) || HazardProtection.isWearingFullRadioHazmat(entityLiving))) {
                if (entityLiving.func_70660_b((Potion)IC2Potion.radiation) != null) {
                    entityLiving.func_70660_b((Potion)IC2Potion.radiation);
                }
                EntityUtils.applyRadioactivity(entityLiving, radiationLevel, stackSize);
            }
        }
    }

    public static void applyRadioactivity(EntityLivingBase aEntity, int aLevel, int aAmountOfItems) {
        if (aLevel > 0 && aEntity != null && aEntity.func_70668_bt() != EnumCreatureAttribute.UNDEAD && aEntity.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD && !ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)aEntity)) {
            PotionEffect tEffect = aEntity.func_70660_b(Potion.field_76421_d);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76419_f);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76431_k);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76437_t);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76438_s);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76425_a[24]);
            aEntity.func_70690_d(new PotionEffect(IC2Potion.radiation.field_76415_H, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
        }
    }

    public static void applyHeatDamageToEntity(int heatLevel, World world, Entity entityHolding) {
        if (!world.field_72995_K && heatLevel > 0 && entityHolding instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityHolding;
            if (!((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d && !HazardProtection.isWearingFullHeatHazmat(entityLiving)) {
                GTUtility.applyHeatDamage(entityLiving, heatLevel);
            }
        }
    }

    public static void doDamage(Entity entity, DamageSource dmg, int i) {
        entity.func_70097_a(dmg, (float)i);
    }

    public static void registerDropsForMob(Class<?> aMobClass, ItemStack aStack, int aMaxAmount, int aChance) {
        EntityDeathHandler.registerDropsForMob(aMobClass, aStack, aMaxAmount, aChance);
    }
}

