/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.client.renderer;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.GTMod;
import gregtech.common.render.GTRendererBlock;
import gtPlusPlus.api.interfaces.ITexturedBlock;
import gtPlusPlus.api.objects.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class CustomOreBlockRenderer
implements ISimpleBlockRenderingHandler {
    public static CustomOreBlockRenderer INSTANCE;
    public final int mRenderID;

    public CustomOreBlockRenderer() {
        INSTANCE = this;
        this.mRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
        Logger.INFO("Registered Custom Ore Block Renderer.");
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        aRenderer.field_147863_w = false;
        aRenderer.field_147844_c = true;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        ITexturedBlock textures = (ITexturedBlock)aBlock;
        GTRendererBlock.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, textures.getTexture(ForgeDirection.DOWN), true);
        GTRendererBlock.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, textures.getTexture(ForgeDirection.UP), true);
        GTRendererBlock.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, textures.getTexture(ForgeDirection.NORTH), true);
        GTRendererBlock.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, textures.getTexture(ForgeDirection.SOUTH), true);
        GTRendererBlock.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, textures.getTexture(ForgeDirection.WEST), true);
        GTRendererBlock.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, textures.getTexture(ForgeDirection.EAST), true);
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        aRenderer.field_147844_c = false;
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        if (!(aBlock instanceof ITexturedBlock)) {
            return false;
        }
        ITexturedBlock textures = (ITexturedBlock)aBlock;
        aRenderer.field_147863_w = Minecraft.func_71379_u() && GTMod.proxy.mRenderTileAmbientOcclusion;
        aRenderer.field_147844_c = false;
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GTRendererBlock.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, textures.getTexture(ForgeDirection.DOWN), true);
        GTRendererBlock.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, textures.getTexture(ForgeDirection.UP), true);
        GTRendererBlock.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, textures.getTexture(ForgeDirection.NORTH), true);
        GTRendererBlock.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, textures.getTexture(ForgeDirection.SOUTH), true);
        GTRendererBlock.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, textures.getTexture(ForgeDirection.WEST), true);
        GTRendererBlock.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, textures.getTexture(ForgeDirection.EAST), true);
        aRenderer.field_147863_w = false;
        return true;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return this.mRenderID;
    }
}

